/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.thymeleaf;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.thymeleaf.ThymeleafConstants;
import org.apache.camel.component.thymeleaf.ThymeleafResolverType;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.DefaultTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;
import org.thymeleaf.templateresolver.UrlTemplateResolver;
import org.thymeleaf.templateresolver.WebApplicationTemplateResolver;
import org.thymeleaf.web.IWebApplication;
import org.thymeleaf.web.servlet.JakartaServletWebApplication;

@UriEndpoint(firstVersion="4.1.0", scheme="thymeleaf", title="Thymeleaf", syntax="thymeleaf:resourceUri", producerOnly=true, category={Category.TRANSFORMATION}, headersClass=ThymeleafConstants.class)
public class ThymeleafEndpoint
extends ResourceEndpoint {
    private TemplateEngine templateEngine;
    private String template;
    private JakartaServletWebApplication jakartaServletWebApplication;
    @UriParam(defaultValue="CLASS_LOADER", description="The type of resolver to be used by the template engine.", javaType="org.apache.camel.component.thymeleaf.ThymeleafResolverType")
    private ThymeleafResolverType resolver = ThymeleafResolverType.CLASS_LOADER;
    @UriParam(description="The template mode to be applied to templates.")
    private String templateMode;
    @UriParam(description="An optional prefix added to template names to convert them into resource names.")
    private String prefix;
    @UriParam(description="An optional suffix added to template names to convert them into resource names.")
    private String suffix;
    @UriParam(description="The character encoding to be used for reading template resources.")
    private String encoding;
    @UriParam(description="The order in which this template will be resolved as part of the resolver chain.")
    private Integer order;
    @UriParam(description="Whether a template resources will be checked for existence before being returned.")
    private Boolean checkExistence;
    @UriParam(description="The cache Time To Live for templates, expressed in milliseconds.")
    private Long cacheTimeToLive;
    @UriParam(description="Whether templates have to be considered cacheable or not.")
    private Boolean cacheable;

    public ThymeleafEndpoint() {
    }

    public ThymeleafEndpoint(String endpointURI, Component component, String resourceURI) {
        super(endpointURI, component, resourceURI);
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "thymeleaf:" + this.getResourceUri();
    }

    public String getTemplateMode() {
        return this.templateMode;
    }

    public void setTemplateMode(String templateMode) {
        this.templateMode = templateMode;
    }

    public ThymeleafResolverType getResolver() {
        return this.resolver;
    }

    public void setResolver(ThymeleafResolverType resolver) {
        this.resolver = resolver;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Boolean getCheckExistence() {
        return this.checkExistence;
    }

    public void setCheckExistence(Boolean checkExistence) {
        this.checkExistence = checkExistence;
    }

    public Long getCacheTimeToLive() {
        return this.cacheTimeToLive;
    }

    public void setCacheTimeToLive(Long cacheTimeToLive) {
        this.cacheTimeToLive = cacheTimeToLive;
    }

    public Boolean getCacheable() {
        return this.cacheable;
    }

    public void setCacheable(Boolean cacheable) {
        this.cacheable = cacheable;
    }

    protected synchronized TemplateEngine getTemplateEngine() {
        if (this.templateEngine == null) {
            ITemplateResolver templateResolver = switch (this.resolver) {
                case ThymeleafResolverType.CLASS_LOADER -> this.classLoaderTemplateResolver();
                case ThymeleafResolverType.DEFAULT -> this.defaultTemplateResolver();
                case ThymeleafResolverType.FILE -> this.fileTemplateResolver();
                case ThymeleafResolverType.STRING -> this.stringTemplateResolver();
                case ThymeleafResolverType.URL -> this.urlTemplateResolver();
                case ThymeleafResolverType.WEB_APP -> this.webApplicationTemplateResolver();
                default -> throw new RuntimeCamelException("cannot determine TemplateResolver for type " + this.resolver);
            };
            this.templateEngine = new TemplateEngine();
            this.templateEngine.setTemplateResolver(templateResolver);
        }
        return this.templateEngine;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public void setJakartaServletWebApplication(JakartaServletWebApplication jakartaServletWebApplication) {
        this.jakartaServletWebApplication = jakartaServletWebApplication;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void clearContentCache() {
        if (this.templateEngine != null) {
            this.templateEngine.clearTemplateCache();
        }
    }

    public ThymeleafEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return (ThymeleafEndpoint)this.getCamelContext().getEndpoint(newUri, ThymeleafEndpoint.class);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        String newResourceUri = (String)exchange.getIn().getHeader("CamelThymeleafResourceUri", String.class);
        if (newResourceUri != null) {
            exchange.getIn().removeHeader("CamelThymeleafResourceUri");
            this.log.debug("{} set to {}, creating new endpoint to handle exchange", (Object)"CamelThymeleafResourceUri", (Object)newResourceUri);
            try (ThymeleafEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);){
                newEndpoint.onExchange(exchange);
            }
            return;
        }
        String template = (String)exchange.getIn().getHeader("CamelThymeleafTemplate", String.class);
        if (template != null) {
            this.template = template;
            exchange.getIn().removeHeader("CamelThymeleafTemplate");
        } else {
            this.template = path;
        }
        Map dataModel = (Map)exchange.getIn().getHeader("CamelThymeleafVariableMap", Map.class);
        if (dataModel == null) {
            dataModel = ExchangeHelper.createVariableMap((Exchange)exchange, (boolean)this.isAllowContextMapAll());
        } else {
            ExchangeHelper.populateVariableMap((Exchange)exchange, (Map)dataModel, (boolean)this.isAllowContextMapAll());
            exchange.getIn().removeHeader("CamelThymeleafVariableMap");
        }
        TemplateEngine templateEngine = this.getTemplateEngine();
        Context context = new Context();
        context.setVariables(dataModel);
        String buffer = templateEngine.process(this.template, (IContext)context);
        ExchangeHelper.setInOutBodyPatternAware((Exchange)exchange, (Object)buffer);
    }

    private ITemplateResolver classLoaderTemplateResolver() {
        ClassLoaderTemplateResolver resolver = new ClassLoaderTemplateResolver();
        if (this.cacheable != null) {
            resolver.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheTimeToLive != null) {
            resolver.setCacheTTLMs(this.cacheTimeToLive);
        }
        if (this.encoding != null) {
            resolver.setCharacterEncoding(this.encoding);
        }
        if (this.checkExistence != null) {
            resolver.setCheckExistence(this.checkExistence.booleanValue());
        }
        if (this.order != null) {
            resolver.setOrder(this.order);
        }
        if (this.prefix != null) {
            resolver.setPrefix(this.prefix);
        }
        if (this.suffix != null) {
            resolver.setSuffix(this.suffix);
        }
        if (this.templateMode != null) {
            resolver.setTemplateMode(this.templateMode);
        }
        if (this.template == null) {
            throw new RuntimeCamelException("template must be provided");
        }
        return resolver;
    }

    private ITemplateResolver defaultTemplateResolver() {
        DefaultTemplateResolver resolver = new DefaultTemplateResolver();
        if (this.checkExistence != null) {
            resolver.setCheckExistence(this.checkExistence.booleanValue());
        }
        if (this.order != null) {
            resolver.setOrder(this.order);
        }
        if (this.templateMode != null) {
            resolver.setTemplateMode(this.templateMode);
        }
        if (this.template == null) {
            throw new RuntimeCamelException("template must be provided");
        }
        resolver.setTemplate(this.template);
        return resolver;
    }

    private ITemplateResolver fileTemplateResolver() {
        FileTemplateResolver resolver = new FileTemplateResolver();
        if (this.cacheable != null) {
            resolver.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheTimeToLive != null) {
            resolver.setCacheTTLMs(this.cacheTimeToLive);
        }
        if (this.encoding != null) {
            resolver.setCharacterEncoding(this.encoding);
        }
        if (this.checkExistence != null) {
            resolver.setCheckExistence(this.checkExistence.booleanValue());
        }
        if (this.order != null) {
            resolver.setOrder(this.order);
        }
        if (this.prefix != null) {
            resolver.setPrefix(this.prefix);
        }
        if (this.suffix != null) {
            resolver.setSuffix(this.suffix);
        }
        if (this.templateMode != null) {
            resolver.setTemplateMode(this.templateMode);
        }
        if (this.template == null) {
            throw new RuntimeCamelException("template must be provided");
        }
        return resolver;
    }

    private ITemplateResolver stringTemplateResolver() {
        StringTemplateResolver resolver = new StringTemplateResolver();
        if (this.cacheable != null) {
            resolver.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheTimeToLive != null) {
            resolver.setCacheTTLMs(this.cacheTimeToLive);
        }
        if (this.checkExistence != null) {
            resolver.setCheckExistence(this.checkExistence.booleanValue());
        }
        if (this.order != null) {
            resolver.setOrder(this.order);
        }
        if (this.templateMode != null) {
            resolver.setTemplateMode(this.templateMode);
        }
        if (this.template == null) {
            throw new RuntimeCamelException("template must be provided");
        }
        return resolver;
    }

    private ITemplateResolver urlTemplateResolver() {
        UrlTemplateResolver resolver = new UrlTemplateResolver();
        if (this.cacheable != null) {
            resolver.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheTimeToLive != null) {
            resolver.setCacheTTLMs(this.cacheTimeToLive);
        }
        if (this.encoding != null) {
            resolver.setCharacterEncoding(this.encoding);
        }
        if (this.order != null) {
            resolver.setOrder(this.order);
        }
        if (this.prefix != null) {
            resolver.setPrefix(this.prefix);
        }
        if (this.suffix != null) {
            resolver.setSuffix(this.suffix);
        }
        if (this.templateMode != null) {
            resolver.setTemplateMode(this.templateMode);
        }
        if (this.template == null) {
            throw new RuntimeCamelException("template must be provided");
        }
        return resolver;
    }

    private ITemplateResolver webApplicationTemplateResolver() {
        WebApplicationTemplateResolver resolver = new WebApplicationTemplateResolver((IWebApplication)this.jakartaServletWebApplication);
        if (this.cacheable != null) {
            resolver.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheTimeToLive != null) {
            resolver.setCacheTTLMs(this.cacheTimeToLive);
        }
        if (this.encoding != null) {
            resolver.setCharacterEncoding(this.encoding);
        }
        if (this.checkExistence != null) {
            resolver.setCheckExistence(this.checkExistence.booleanValue());
        }
        if (this.order != null) {
            resolver.setOrder(this.order);
        }
        if (this.prefix != null) {
            resolver.setPrefix(this.prefix);
        }
        if (this.suffix != null) {
            resolver.setSuffix(this.suffix);
        }
        if (this.templateMode != null) {
            resolver.setTemplateMode(this.templateMode);
        }
        if (this.template == null) {
            throw new RuntimeCamelException("template must be provided");
        }
        return resolver;
    }
}

