/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.util.srcgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.camel.tooling.util.srcgen.Annotation;
import org.apache.camel.tooling.util.srcgen.GenericType;
import org.apache.camel.tooling.util.srcgen.Javadoc;

public class Field {
    String literalInit;
    List<Annotation> annotations = new ArrayList<Annotation>();
    Javadoc javadoc = new Javadoc();
    boolean isPrivate;
    boolean isPublic;
    boolean isStatic;
    boolean isFinal;
    String name;
    GenericType type;
    String comment;

    public Field setPublic() {
        this.isPublic = true;
        this.isPrivate = false;
        return this;
    }

    public Field setPrivate() {
        this.isPublic = false;
        this.isPrivate = true;
        return this;
    }

    public String getName() {
        return null;
    }

    public Field setName(String name) {
        this.name = name;
        return this;
    }

    public GenericType getType() {
        return this.type;
    }

    public Field setType(Class<?> type) {
        return this.setType(new GenericType(type));
    }

    public Field setType(GenericType type) {
        this.type = type;
        return this;
    }

    public Field setStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    public Field setFinal(boolean isFinal) {
        this.isFinal = isFinal;
        return this;
    }

    public Field setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public String getLiteralInitializer() {
        return this.literalInit;
    }

    public Field setLiteralInitializer(String init) {
        this.literalInit = init;
        return this;
    }

    public Field setStringInitializer(String init) {
        this.literalInit = Annotation.quote(init);
        return this;
    }

    public Annotation addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        Annotation ann = new Annotation(clazz);
        this.annotations.add(ann);
        return ann;
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.annotations.stream().anyMatch(a -> Objects.equals(a.getType(), clazz));
    }

    public Annotation getAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.annotations.stream().filter(a -> Objects.equals(a.getType(), clazz)).findAny().orElse(null);
    }

    public Javadoc getJavaDoc() {
        return this.javadoc;
    }
}

