/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.util;

import org.apache.camel.tooling.util.Version;

public final class CamelVersionHelper {
    private CamelVersionHelper() {
    }

    public static boolean isGE(String base, String other) {
        return CamelVersionHelper.isGE(base, other, false);
    }

    public static boolean isGE(String base, String other, boolean majorMinorOnly) {
        if (base == null || base.isEmpty()) {
            throw new IllegalArgumentException("Empty base version");
        }
        if (other == null || other.isEmpty()) {
            throw new IllegalArgumentException("Empty other version");
        }
        base = base.replaceAll("[^\\d|^\\.]", "");
        other = other.replaceAll("[^\\d|^\\.]", "");
        if (!base.matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        if (!other.matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        Version ver2 = new Version(other);
        Version ver1 = new Version(base);
        return ver2.compareTo(ver1) >= 0;
    }

    public static String prevMinor(String base) {
        if (base == null || base.isEmpty()) {
            throw new IllegalArgumentException("Empty base version");
        }
        if (!(base = base.replaceAll("[^\\d|^\\.]", "")).matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        Version ver = new Version(base);
        return ver.prevMinor();
    }
}

