/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.EagerFormParsingHandler;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.MimeMappings;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.undertow.ExchangeHeaders;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndertowConsumer
extends DefaultConsumer
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowConsumer.class);
    private HttpHandlerRegistrationInfo registrationInfo;

    public UndertowConsumer(UndertowEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public UndertowEndpoint getEndpoint() {
        return (UndertowEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.getEndpoint().getComponent().registerConsumer(this);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.getEndpoint().getComponent().unregisterConsumer(this);
    }

    public HttpHandlerRegistrationInfo getHttpHandlerRegistrationInfo() {
        if (this.registrationInfo == null) {
            UndertowEndpoint endpoint = this.getEndpoint();
            this.registrationInfo = new HttpHandlerRegistrationInfo();
            this.registrationInfo.setUri(endpoint.getHttpURI());
            this.registrationInfo.setMethodRestrict(endpoint.getHttpMethodRestrict());
            this.registrationInfo.setMatchOnUriPrefix(endpoint.getMatchOnUriPrefix());
        }
        return this.registrationInfo;
    }

    public HttpHandler getHttpHandler() {
        return Handlers.httpContinueRead((HttpHandler)new EagerFormParsingHandler().setNext((HttpHandler)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange httpExchange) throws Exception {
        HttpString requestMethod = httpExchange.getRequestMethod();
        if (Methods.OPTIONS.equals(requestMethod) && !this.getEndpoint().isOptionsEnabled()) {
            String allowedMethods = this.getEndpoint().getHttpMethodRestrict() != null ? "OPTIONS," + this.getEndpoint().getHttpMethodRestrict() : "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
            httpExchange.setStatusCode(200);
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_LENGTH, 0L);
            httpExchange.getResponseHeaders().put(Headers.ALLOW, allowedMethods);
            httpExchange.getResponseSender().close();
            return;
        }
        if (httpExchange.isInIoThread()) {
            httpExchange.dispatch((HttpHandler)this);
            return;
        }
        Exchange camelExchange = this.getEndpoint().createExchange(httpExchange);
        this.createUoW(camelExchange);
        try {
            this.getProcessor().process(camelExchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException((Throwable)e);
        }
        finally {
            this.doneUoW(camelExchange);
        }
        Object body = this.getResponseBody(httpExchange, camelExchange);
        TypeConverter tc = this.getEndpoint().getCamelContext().getTypeConverter();
        if (body == null) {
            LOG.trace("No payload to send as reply for exchange: " + camelExchange);
            httpExchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_TYPE, (String)MimeMappings.DEFAULT_MIME_MAPPINGS.get("txt"));
            httpExchange.getResponseSender().send("No response available");
        } else {
            ByteBuffer bodyAsByteBuffer = (ByteBuffer)tc.convertTo(ByteBuffer.class, body);
            httpExchange.getResponseSender().send(bodyAsByteBuffer);
        }
        httpExchange.getResponseSender().close();
    }

    private Object getResponseBody(HttpServerExchange httpExchange, Exchange camelExchange) throws IOException {
        Object result = camelExchange.hasOut() ? this.getEndpoint().getUndertowHttpBinding().toHttpResponse(httpExchange, camelExchange.getOut()) : this.getEndpoint().getUndertowHttpBinding().toHttpResponse(httpExchange, camelExchange.getIn());
        return result;
    }
}

