/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.camel.util.CamelURIParser;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.Pair;
import org.apache.camel.util.SensitiveUtils;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URIScanner;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class URISupport {
    public static final String RAW_TOKEN_PREFIX = "RAW";
    public static final char[] RAW_TOKEN_START = new char[]{'(', '{'};
    public static final char[] RAW_TOKEN_END = new char[]{')', '}'};
    private static final String TEXT_BLOCK_MARKER = System.lineSeparator();
    private static final Pattern TEXT_BLOCK_PATTERN = Pattern.compile("\n\\s*");
    private static final Pattern ALL_SECRETS = Pattern.compile("([?&][^=]*(?:" + SensitiveUtils.getSensitivePattern() + ")[^=]*)=(RAW(([{][^}]*[}])|([(][^)]*[)]))|[^&]*)", 2);
    private static final Pattern USERINFO_PASSWORD = Pattern.compile("(.*://.*?:)(.*)(@)");
    private static final Pattern PATH_USERINFO_PASSWORD = Pattern.compile("(.*?:)(.*)(@)");
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String EMPTY_QUERY_STRING = "";

    private URISupport() {
    }

    public static String sanitizeUri(String uri) {
        String sanitized = uri;
        if (uri != null) {
            sanitized = ALL_SECRETS.matcher(sanitized).replaceAll("$1=xxxxxx");
            sanitized = USERINFO_PASSWORD.matcher(sanitized).replaceFirst("$1xxxxxx$3");
        }
        return sanitized;
    }

    public static String textBlockToSingleLine(String uri) {
        if (uri != null && uri.contains(TEXT_BLOCK_MARKER)) {
            uri = TEXT_BLOCK_PATTERN.matcher(uri).replaceAll(EMPTY_QUERY_STRING);
            uri = uri.trim();
        }
        return uri;
    }

    public static String sanitizePath(String path) {
        String sanitized = path;
        if (path != null) {
            sanitized = PATH_USERINFO_PASSWORD.matcher(sanitized).replaceFirst("$1xxxxxx$3");
        }
        return sanitized;
    }

    public static String extractRemainderPath(URI u, boolean useRaw) {
        String path;
        String string = path = useRaw ? u.getRawSchemeSpecificPart() : u.getSchemeSpecificPart();
        if (path.startsWith("//")) {
            path = path.substring(2);
        }
        return StringHelper.before(path, "?", path);
    }

    public static String extractQuery(String uri) {
        if (uri == null) {
            return null;
        }
        return StringHelper.after(uri, "?");
    }

    public static String stripQuery(String uri) {
        return StringHelper.before(uri, "?", uri);
    }

    public static Map<String, Object> parseQuery(String uri) throws URISyntaxException {
        return URISupport.parseQuery(uri, false);
    }

    public static Map<String, Object> parseQuery(String uri, boolean useRaw) throws URISyntaxException {
        return URISupport.parseQuery(uri, useRaw, false);
    }

    public static Map<String, Object> parseQuery(String uri, boolean useRaw, boolean lenient) throws URISyntaxException {
        if (uri == null || uri.isEmpty()) {
            return Collections.emptyMap();
        }
        if (!lenient && uri.endsWith("&")) {
            throw new URISyntaxException(uri, "Invalid uri syntax: Trailing & marker found. Check the uri and remove the trailing & marker.");
        }
        URIScanner scanner = new URIScanner();
        return scanner.parseQuery(uri, useRaw);
    }

    public static List<Pair<Integer>> scanRaw(String str) {
        return URIScanner.scanRaw(str);
    }

    public static boolean isRaw(int index, List<Pair<Integer>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return false;
        }
        for (Pair<Integer> pair : pairs) {
            if (index < pair.getLeft()) {
                return false;
            }
            if (index > pair.getRight()) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> parseParameters(URI uri) throws URISyntaxException {
        String query = URISupport.prepareQuery(uri);
        if (query == null) {
            return new LinkedHashMap<String, Object>(0);
        }
        return URISupport.parseQuery(query);
    }

    public static String prepareQuery(URI uri) {
        String query = uri.getQuery();
        if (query == null) {
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            query = StringHelper.after(schemeSpecificPart, "?");
        } else if (query.indexOf(63) == 0) {
            query = query.substring(1);
        }
        return query;
    }

    public static void resolveRawParameterValues(Map<String, Object> parameters) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (entry.getValue() == null) continue;
            Object value = entry.getValue();
            if (value instanceof List) {
                List list = (List)value;
                for (int i = 0; i < list.size(); ++i) {
                    String str;
                    String raw;
                    Object obj = list.get(i);
                    if (obj == null || (raw = URIScanner.resolveRaw(str = obj.toString())) == null) continue;
                    String s = raw.replace("%25", "%");
                    list.set(i, s);
                }
                continue;
            }
            String str = entry.getValue().toString();
            String raw = URIScanner.resolveRaw(str);
            if (raw == null) continue;
            String s = raw.replace("%25", "%");
            entry.setValue(s);
        }
    }

    public static URI createURIWithQuery(URI uri, String query) throws URISyntaxException {
        ObjectHelper.notNull(uri, "uri");
        Object s = uri.toString();
        String before = StringHelper.before((String)s, "?");
        if (before == null) {
            before = StringHelper.before((String)s, "#");
        }
        if (before != null) {
            s = before;
        }
        if (query != null) {
            s = (String)s + "?" + query;
        }
        if (!((String)s).contains("#") && uri.getFragment() != null) {
            s = (String)s + "#" + uri.getFragment();
        }
        return new URI((String)s);
    }

    public static String stripPrefix(String value, String prefix) {
        if (value == null || prefix == null) {
            return value;
        }
        if (value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public static String stripSuffix(String value, String suffix) {
        if (value == null || suffix == null) {
            return value;
        }
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    public static String createQueryString(Map<String, Object> options) {
        Set<String> keySet = options.keySet();
        return URISupport.createQueryString(keySet.toArray(new String[0]), options, true);
    }

    public static String createQueryString(Map<String, Object> options, boolean encode) {
        return URISupport.createQueryString(options.keySet(), options, encode);
    }

    private static String createQueryString(String[] sortedKeys, Map<String, Object> options, boolean encode) {
        if (options.isEmpty()) {
            return EMPTY_QUERY_STRING;
        }
        StringBuilder rc = new StringBuilder(128);
        boolean first = true;
        for (String key : sortedKeys) {
            if (first) {
                first = false;
            } else {
                rc.append("&");
            }
            Object value = options.get(key);
            if (value instanceof List) {
                List list = (List)value;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    String s = (String)it.next();
                    URISupport.appendQueryStringParameter(key, s, rc, encode);
                    if (!it.hasNext()) continue;
                    rc.append("&");
                }
                continue;
            }
            String s = value != null ? value.toString() : null;
            URISupport.appendQueryStringParameter(key, s, rc, encode);
        }
        return rc.toString();
    }

    @Deprecated
    public static String createQueryString(Map<String, String> options, String ampersand, boolean encode) {
        if (!options.isEmpty()) {
            StringBuilder rc = new StringBuilder();
            boolean first = true;
            for (String key : options.keySet()) {
                if (first) {
                    first = false;
                } else {
                    rc.append(ampersand);
                }
                String value = options.get(key);
                String s = value != null ? value.toString() : null;
                URISupport.appendQueryStringParameter(key, s, rc, encode);
            }
            return rc.toString();
        }
        return EMPTY_QUERY_STRING;
    }

    @Deprecated
    public static String createQueryString(Collection<String> sortedKeys, Map<String, Object> options, boolean encode) {
        return URISupport.createQueryString(sortedKeys.toArray(new String[0]), options, encode);
    }

    private static void appendQueryStringParameter(String key, String value, StringBuilder rc, boolean encode) {
        if (encode) {
            String encoded = URLEncoder.encode(key, CHARSET);
            rc.append(encoded);
        } else {
            rc.append(key);
        }
        if (value == null) {
            return;
        }
        rc.append("=");
        String raw = URIScanner.resolveRaw(value);
        if (raw != null) {
            String s = URIScanner.replacePercent(value);
            rc.append(s);
        } else if (encode) {
            String encoded = URLEncoder.encode(value, CHARSET);
            rc.append(encoded);
        } else {
            rc.append(value);
        }
    }

    public static URI createRemainingURI(URI originalURI, Map<String, Object> params) throws URISyntaxException {
        String s = URISupport.createQueryString(params);
        if (s.isEmpty()) {
            s = null;
        }
        return URISupport.createURIWithQuery(originalURI, s);
    }

    public static String appendParametersToURI(String originalURI, Map<String, Object> newParameters) throws URISyntaxException {
        URI uri = new URI(URISupport.normalizeUri(originalURI));
        Map<String, Object> parameters = URISupport.parseParameters(uri);
        parameters.putAll(newParameters);
        return URISupport.createRemainingURI(uri, parameters).toString();
    }

    public static String normalizeUri(String uri) throws URISyntaxException {
        String[] parts = CamelURIParser.fastParseUri(uri);
        if (parts != null) {
            if (parts == CamelURIParser.URI_ALREADY_NORMALIZED) {
                return uri;
            }
            return URISupport.doFastNormalizeUri(parts);
        }
        return URISupport.doComplexNormalizeUri(uri);
    }

    public static URI normalizeUriAsURI(String uri) throws URISyntaxException {
        uri = URISupport.textBlockToSingleLine(uri);
        return new URI(UnsafeUriCharactersEncoder.encode(uri, true));
    }

    private static String doComplexNormalizeUri(String uri) throws URISyntaxException {
        String query;
        uri = URISupport.textBlockToSingleLine(uri);
        URI u = new URI(UnsafeUriCharactersEncoder.encode(uri, true));
        String scheme = u.getScheme();
        Object path = u.getSchemeSpecificPart();
        if (scheme == null || path == null) {
            return uri;
        }
        int start = ((String)path).startsWith("//") ? 2 : 0;
        int end = ((String)path).indexOf(63);
        if (start == 0 && end == 0 || start == 2 && end == 2) {
            path = EMPTY_QUERY_STRING;
        } else {
            if (start != 0 && end == -1) {
                path = ((String)path).substring(start);
            } else if (end != -1) {
                path = ((String)path).substring(start, end);
            }
            path = scheme.startsWith("http") ? UnsafeUriCharactersEncoder.encodeHttpURI((String)path) : UnsafeUriCharactersEncoder.encode((String)path);
        }
        int idxPath = ((String)path).indexOf(47);
        if (StringHelper.countChar((String)path, '@', idxPath) > 1) {
            String userInfoPath = idxPath > 0 ? ((String)path).substring(0, idxPath) : path;
            int max = userInfoPath.lastIndexOf(64);
            String before = userInfoPath.substring(0, max);
            String after = ((String)path).substring(max);
            before = before.replace("@", "%40");
            path = before + after;
        }
        if ((query = URISupport.prepareQuery(u)) == null) {
            return URISupport.buildUri(scheme, (String)path, null);
        }
        Map<String, Object> parameters = URISupport.parseQuery(query, false, false);
        if (parameters.size() == 1) {
            query = URISupport.createQueryString(parameters);
            return URISupport.buildUri(scheme, (String)path, query);
        }
        Set<String> keySet = parameters.keySet();
        Object[] parametersArray = keySet.toArray(new String[0]);
        Arrays.sort(parametersArray);
        query = URISupport.createQueryString((String[])parametersArray, parameters, true);
        return URISupport.buildUri(scheme, (String)path, query);
    }

    private static String doFastNormalizeUri(String[] parts) throws URISyntaxException {
        String scheme = parts[0];
        String path = parts[1];
        String query = parts[2];
        if (query == null) {
            return URISupport.buildUri(scheme, path, null);
        }
        return URISupport.buildReorderingParameters(scheme, path, query);
    }

    private static String buildReorderingParameters(String scheme, String path, String query) throws URISyntaxException {
        Map<String, Object> parameters = null;
        if (query.indexOf(38) != -1) {
            parameters = URISupport.parseQuery(query, false, false);
        }
        if (parameters == null || parameters.size() == 1) {
            return URISupport.buildUri(scheme, path, query);
        }
        Set<String> entries = parameters.keySet();
        boolean sort = false;
        String prev = null;
        for (String key : entries) {
            if (prev == null) {
                prev = key;
                continue;
            }
            int comp = key.compareTo(prev);
            if (comp < 0) {
                sort = true;
                break;
            }
            prev = key;
        }
        if (sort) {
            Object[] array = entries.toArray(new String[entries.size()]);
            Arrays.sort(array);
            query = URISupport.createQueryString((String[])array, parameters, true);
        }
        return URISupport.buildUri(scheme, path, query);
    }

    private static String buildUri(String scheme, String path, String query) {
        int len = scheme.length() + 3 + path.length();
        if (query != null) {
            StringBuilder sb = new StringBuilder(len += 1 + query.length());
            sb.append(scheme).append("://").append(path).append('?').append(query);
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(len);
        sb.append(scheme).append("://").append(path);
        return sb.toString();
    }

    public static Map<String, Object> extractProperties(Map<String, Object> properties, String optionPrefix) {
        LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>(properties.size());
        Iterator<Map.Entry<String, Object>> it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = properties.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            it.remove();
        }
        return rc;
    }

    private static String makeUri(String uriWithoutQuery, String query) {
        int len = uriWithoutQuery.length();
        if (query != null) {
            StringBuilder sb = new StringBuilder(len += 1 + query.length());
            sb.append(uriWithoutQuery).append('?').append(query);
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(len);
        sb.append(uriWithoutQuery);
        return sb.toString();
    }

    public static String getDecodeQuery(String uri) {
        try {
            URI u = new URI(uri);
            String query = URISupport.prepareQuery(u);
            String uriWithoutQuery = URISupport.stripQuery(uri);
            if (query == null) {
                return uriWithoutQuery;
            }
            Map<String, Object> parameters = URISupport.parseQuery(query, false, false);
            if (parameters.size() == 1) {
                query = URISupport.createQueryString(parameters);
                return URISupport.makeUri(uriWithoutQuery, query);
            }
            Set<String> keySet = parameters.keySet();
            Object[] parametersArray = keySet.toArray(new String[0]);
            Arrays.sort(parametersArray);
            query = URISupport.createQueryString((String[])parametersArray, parameters, true);
            return URISupport.makeUri(uriWithoutQuery, query);
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public static String pathAndQueryOf(URI uri) {
        String query;
        String path = uri.getPath();
        Object pathAndQuery = path;
        if (ObjectHelper.isEmpty(path)) {
            pathAndQuery = "/";
        }
        if (ObjectHelper.isNotEmpty(query = uri.getQuery())) {
            pathAndQuery = (String)pathAndQuery + "?" + query;
        }
        return pathAndQuery;
    }

    public static String joinPaths(String ... paths) {
        if (paths == null || paths.length == 0) {
            return EMPTY_QUERY_STRING;
        }
        StringBuilder joined = new StringBuilder();
        boolean addedLast = false;
        for (int i = paths.length - 1; i >= 0; --i) {
            String path = paths[i];
            if (!ObjectHelper.isNotEmpty(path)) continue;
            if (addedLast) {
                path = URISupport.stripSuffix(path, "/");
            }
            addedLast = true;
            if (path.charAt(0) == '/') {
                joined.insert(0, path);
                continue;
            }
            if (i > 0) {
                joined.insert(0, '/').insert(1, path);
                continue;
            }
            joined.insert(0, path);
        }
        return joined.toString();
    }

    public static String buildMultiValueQuery(String key, Iterable<Object> values) {
        StringBuilder sb = new StringBuilder();
        for (Object v : values) {
            if (!sb.isEmpty()) {
                sb.append("&");
            }
            sb.append(key);
            sb.append("=");
            sb.append(v);
        }
        return sb.toString();
    }

    public static String removeNoiseFromUri(String uri) {
        String changed;
        String before = StringHelper.before(uri, "?");
        String after = StringHelper.after(uri, "?");
        if (before != null && after != null && !after.equals(changed = after.replaceAll("&\\s+", "&").trim())) {
            return before.trim() + "?" + changed;
        }
        return uri;
    }
}

