/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.velocity;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceBasedEndpoint;
import org.apache.camel.component.velocity.VelocityComponent;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.CommonsLogLogChute;
import org.springframework.core.io.Resource;

public class VelocityEndpoint
extends ResourceBasedEndpoint {
    private VelocityEngine velocityEngine;
    private boolean loaderCache = true;
    private String encoding;
    private String propertiesFile;

    public VelocityEndpoint() {
    }

    public VelocityEndpoint(String uri, VelocityComponent component, String resourceUri) {
        super(uri, (Component)component, resourceUri, null);
    }

    public boolean isSingleton() {
        return true;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "velocity:" + this.getResourceUri();
    }

    private synchronized VelocityEngine getVelocityEngine() throws Exception {
        if (this.velocityEngine == null) {
            this.velocityEngine = new VelocityEngine();
            Properties properties = new Properties();
            if (ObjectHelper.isNotEmpty((Object)this.getPropertiesFile())) {
                Resource resource = this.getResourceLoader().getResource(this.getPropertiesFile());
                InputStream reader = resource.getInputStream();
                properties.load(reader);
                this.log.info((Object)("Loaded the velocity configuration file " + this.getPropertiesFile()));
            }
            properties.setProperty("file.resource.loader.cache", this.isLoaderCache() ? "true" : "false");
            properties.setProperty("resource.loader", "file, class");
            properties.setProperty("class.resource.loader.description", "Velocity Classpath Resource Loader");
            properties.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            properties.setProperty("runtime.log.logsystem.class", CommonsLogLogChute.class.getName());
            properties.setProperty("runtime.log.logsystem.commons.logging.name", VelocityEndpoint.class.getName());
            this.velocityEngine.init(properties);
        }
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public boolean isLoaderCache() {
        return this.loaderCache;
    }

    public void setLoaderCache(boolean loaderCache) {
        this.loaderCache = loaderCache;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setPropertiesFile(String file) {
        this.propertiesFile = file;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public VelocityEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting endpoint with URI: " + newUri));
        }
        return (VelocityEndpoint)this.getCamelContext().getEndpoint(newUri);
    }

    protected void onExchange(Exchange exchange) throws Exception {
        Reader reader;
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        String newResourceUri = (String)exchange.getIn().getHeader("CamelVelocityResourceUri", String.class);
        if (newResourceUri != null) {
            exchange.getIn().removeHeader("CamelVelocityResourceUri");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("CamelVelocityResourceUri set to " + newResourceUri + " creating new endpoint to handle exchange"));
            }
            VelocityEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        Resource resource = null;
        String content = (String)exchange.getIn().getHeader("CamelVelocityTemplate", String.class);
        if (content != null) {
            reader = new StringReader(content);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Velocity content read from header CamelVelocityTemplate for endpoint " + this.getEndpointUri()));
            }
            exchange.getIn().removeHeader("CamelVelocityTemplate");
        } else {
            resource = this.getResource();
            ObjectHelper.notNull((Object)resource, (String)"resource");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Velocity content read from resource " + resource + " with resourceUri: " + path + " for endpoint " + this.getEndpointUri()));
            }
            reader = this.getEncoding() != null ? new InputStreamReader(this.getResourceAsInputStream(), this.getEncoding()) : new InputStreamReader(this.getResourceAsInputStream());
        }
        StringWriter buffer = new StringWriter();
        String logTag = ((Object)((Object)this)).getClass().getName();
        Map variableMap = ExchangeHelper.createVariableMap((Exchange)exchange);
        VelocityContext velocityContext = new VelocityContext(variableMap);
        VelocityEngine engine = this.getVelocityEngine();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Velocity is evaluating using velocity context: " + variableMap));
        }
        engine.evaluate((Context)velocityContext, (Writer)buffer, logTag, reader);
        Message out = exchange.getOut();
        out.setBody((Object)buffer.toString());
        Map headers = (Map)velocityContext.get("headers");
        for (Map.Entry entry : headers.entrySet()) {
            out.setHeader((String)entry.getKey(), entry.getValue());
        }
    }
}

