/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.impl.CatalogHelper;

public class SpringBootRuntimeProvider
implements RuntimeProvider {
    private static final String COMPONENT_DIR = "org/apache/camel/springboot/catalog/components";
    private static final String DATAFORMAT_DIR = "org/apache/camel/springboot/catalog/dataformats";
    private static final String LANGUAGE_DIR = "org/apache/camel/springboot/catalog/languages";
    private static final String OTHER_DIR = "org/apache/camel/springboot/catalog/others";
    private static final String COMPONENTS_CATALOG = "org/apache/camel/springboot/catalog/components.properties";
    private static final String DATA_FORMATS_CATALOG = "org/apache/camel/springboot/catalog/dataformats.properties";
    private static final String LANGUAGE_CATALOG = "org/apache/camel/springboot/catalog/languages.properties";
    private static final String OTHER_CATALOG = "org/apache/camel/springboot/catalog/others.properties";
    private CamelCatalog camelCatalog;

    public CamelCatalog getCamelCatalog() {
        return this.camelCatalog;
    }

    public void setCamelCatalog(CamelCatalog camelCatalog) {
        this.camelCatalog = camelCatalog;
    }

    public String getProviderName() {
        return "springboot";
    }

    public String getProviderGroupId() {
        return "org.apache.camel";
    }

    public String getProviderArtifactId() {
        return "camel-catalog-provider-springboot";
    }

    public String getComponentJSonSchemaDirectory() {
        return COMPONENT_DIR;
    }

    public String getDataFormatJSonSchemaDirectory() {
        return DATAFORMAT_DIR;
    }

    public String getLanguageJSonSchemaDirectory() {
        return LANGUAGE_DIR;
    }

    public String getOtherJSonSchemaDirectory() {
        return OTHER_DIR;
    }

    public List<String> findComponentNames() {
        return this.findNames(COMPONENTS_CATALOG);
    }

    public List<String> findDataFormatNames() {
        return this.findNames(DATA_FORMATS_CATALOG);
    }

    public List<String> findLanguageNames() {
        return this.findNames(LANGUAGE_CATALOG);
    }

    public List<String> findOtherNames() {
        return this.findNames(OTHER_CATALOG);
    }

    private List<String> findNames(String pathToPropertyCatalogDescriptor) {
        ArrayList<String> names = new ArrayList<String>();
        try (InputStream is = this.camelCatalog.getVersionManager().getResourceAsStream(pathToPropertyCatalogDescriptor);){
            if (is != null) {
                try {
                    CatalogHelper.loadLines((InputStream)is, names);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return names;
    }
}

