/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.AbstractColumnContainer;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.KeyIterator;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class SSTableExport {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final String KEY_OPTION = "k";
    private static final String EXCLUDEKEY_OPTION = "x";
    private static final String ENUMERATEKEYS_OPTION = "e";
    private static final Options options = new Options();
    private static CommandLine cmd;

    private static void writeKey(PrintStream out, String value) {
        SSTableExport.writeJSON(out, value);
        out.print(": ");
    }

    private static void writeMeta(PrintStream out, AbstractColumnContainer columnContainer) {
        if (columnContainer instanceof ColumnFamily) {
            ColumnFamily columnFamily = (ColumnFamily)columnContainer;
            if (!columnFamily.deletionInfo().equals(DeletionInfo.LIVE)) {
                SSTableExport.writeKey(out, "metadata");
                SSTableExport.writeDeletionInfo(out, columnFamily.deletionInfo().getTopLevelDeletion());
                out.print(",");
            }
            return;
        }
        if (columnContainer instanceof SuperColumn) {
            SuperColumn superColumn = (SuperColumn)columnContainer;
            DeletionInfo deletionInfo = new DeletionInfo(superColumn.getMarkedForDeleteAt(), superColumn.getLocalDeletionTime());
            if (!deletionInfo.equals(DeletionInfo.LIVE)) {
                SSTableExport.writeKey(out, "metadata");
                SSTableExport.writeDeletionInfo(out, deletionInfo.getTopLevelDeletion());
                out.print(",");
            }
            return;
        }
    }

    private static void writeDeletionInfo(PrintStream out, DeletionTime deletionTime) {
        out.print("{");
        SSTableExport.writeKey(out, "deletionInfo");
        SSTableExport.writeJSON(out, deletionTime);
        out.print("}");
    }

    private static void serializeColumns(Iterator<OnDiskAtom> columns, PrintStream out, AbstractType<?> comparator, CFMetaData cfMetaData) {
        while (columns.hasNext()) {
            SSTableExport.writeJSON(out, SSTableExport.serializeColumn(columns.next(), comparator, cfMetaData));
            if (!columns.hasNext()) continue;
            out.print(", ");
        }
    }

    private static void serializeIColumns(Iterator<IColumn> columns, PrintStream out, AbstractType<?> comparator, CFMetaData cfMetaData) {
        while (columns.hasNext()) {
            SSTableExport.writeJSON(out, SSTableExport.serializeColumn(columns.next(), comparator, cfMetaData));
            if (!columns.hasNext()) continue;
            out.print(", ");
        }
    }

    private static List<Object> serializeColumn(OnDiskAtom column, AbstractType<?> comparator, CFMetaData cfMetaData) {
        if (column instanceof IColumn) {
            return SSTableExport.serializeColumn((IColumn)column, comparator, cfMetaData);
        }
        assert (column instanceof RangeTombstone);
        RangeTombstone rt = (RangeTombstone)column;
        ArrayList<Object> serializedColumn = new ArrayList<Object>();
        serializedColumn.add(comparator.getString((ByteBuffer)rt.min));
        serializedColumn.add(comparator.getString((ByteBuffer)rt.max));
        serializedColumn.add(((DeletionTime)rt.data).markedForDeleteAt);
        serializedColumn.add("t");
        serializedColumn.add(((DeletionTime)rt.data).localDeletionTime);
        return serializedColumn;
    }

    private static List<Object> serializeColumn(IColumn column, AbstractType<?> comparator, CFMetaData cfMetaData) {
        ArrayList<Object> serializedColumn = new ArrayList<Object>();
        ByteBuffer name = ByteBufferUtil.clone(column.name());
        ByteBuffer value = ByteBufferUtil.clone(column.value());
        serializedColumn.add(comparator.getString(name));
        if (column instanceof DeletedColumn) {
            serializedColumn.add(ByteBufferUtil.bytesToHex(value));
        } else {
            AbstractType<?> validator = cfMetaData.getValueValidator(cfMetaData.getColumnDefinitionFromColumnName(name));
            serializedColumn.add(validator.getString(value));
        }
        serializedColumn.add(column.timestamp());
        if (column instanceof DeletedColumn) {
            serializedColumn.add("d");
        } else if (column instanceof ExpiringColumn) {
            serializedColumn.add(ENUMERATEKEYS_OPTION);
            serializedColumn.add(((ExpiringColumn)column).getTimeToLive());
            serializedColumn.add(column.getLocalDeletionTime());
        } else if (column instanceof CounterColumn) {
            serializedColumn.add("c");
            serializedColumn.add(((CounterColumn)column).timestampOfLastDelete());
        }
        return serializedColumn;
    }

    private static void serializeRow(SSTableIdentityIterator row, DecoratedKey key, PrintStream out) {
        ColumnFamily columnFamily = row.getColumnFamily();
        boolean isSuperCF = columnFamily.isSuper();
        CFMetaData cfMetaData = columnFamily.metadata();
        AbstractType<?> comparator = columnFamily.getComparator();
        out.print("{");
        SSTableExport.writeKey(out, "key");
        SSTableExport.writeJSON(out, ByteBufferUtil.bytesToHex(key.key));
        out.print(",");
        SSTableExport.writeMeta(out, columnFamily);
        SSTableExport.writeKey(out, "columns");
        out.print(isSuperCF ? "{" : "[");
        if (isSuperCF) {
            while (row.hasNext()) {
                SuperColumn scol = (SuperColumn)row.next();
                assert (scol instanceof IColumn);
                SuperColumn column = scol;
                SSTableExport.writeKey(out, comparator.getString(column.name()));
                out.print("{");
                SSTableExport.writeMeta(out, scol);
                SSTableExport.writeKey(out, "subColumns");
                out.print("[");
                SSTableExport.serializeIColumns(column.getSubColumns().iterator(), out, columnFamily.getSubComparator(), cfMetaData);
                out.print("]");
                out.print("}");
                if (!row.hasNext()) continue;
                out.print(", ");
            }
        } else {
            SSTableExport.serializeColumns(row, out, comparator, cfMetaData);
        }
        out.print(isSuperCF ? "}" : "]");
        out.print("}");
    }

    public static void enumeratekeys(Descriptor desc, PrintStream outs) throws IOException {
        KeyIterator iter = new KeyIterator(desc);
        DecoratedKey lastKey = null;
        while (iter.hasNext()) {
            DecoratedKey key = (DecoratedKey)iter.next();
            if (lastKey != null && lastKey.compareTo(key) > 0) {
                throw new IOException("Key out of order! " + lastKey + " > " + key);
            }
            lastKey = key;
            outs.println(ByteBufferUtil.bytesToHex(key.key));
        }
        iter.close();
        outs.flush();
    }

    public static void export(Descriptor desc, PrintStream outs, Collection<String> toExport, String[] excludes) throws IOException {
        SSTableReader reader = SSTableReader.open(desc);
        SSTableScanner scanner = reader.getDirectScanner();
        IPartitioner partitioner = reader.partitioner;
        if (excludes != null) {
            toExport.removeAll(Arrays.asList(excludes));
        }
        outs.println("[");
        int i = 0;
        DecoratedKey lastKey = null;
        for (String key : toExport) {
            SSTableIdentityIterator row;
            DecoratedKey decoratedKey = partitioner.decorateKey(ByteBufferUtil.hexToBytes(key));
            if (lastKey != null && lastKey.compareTo(decoratedKey) > 0) {
                throw new IOException("Key out of order! " + lastKey + " > " + decoratedKey);
            }
            lastKey = decoratedKey;
            scanner.seekTo(decoratedKey);
            if (!scanner.hasNext() || !(row = (SSTableIdentityIterator)scanner.next()).getKey().equals(decoratedKey)) continue;
            SSTableExport.serializeRow(row, decoratedKey, outs);
            if (i != 0) {
                outs.println(",");
            }
            ++i;
        }
        outs.println("\n]");
        outs.flush();
        scanner.close();
    }

    static void export(SSTableReader reader, PrintStream outs, String[] excludes) throws IOException {
        HashSet<Object> excludeSet = new HashSet();
        if (excludes != null) {
            excludeSet = new HashSet<String>(Arrays.asList(excludes));
        }
        SSTableScanner scanner = reader.getDirectScanner();
        outs.println("[");
        int i = 0;
        while (scanner.hasNext()) {
            SSTableIdentityIterator row = (SSTableIdentityIterator)scanner.next();
            String currentKey = ByteBufferUtil.bytesToHex(row.getKey().key);
            if (excludeSet.contains(currentKey)) continue;
            if (i != 0) {
                outs.println(",");
            }
            SSTableExport.serializeRow(row, row.getKey(), outs);
            ++i;
        }
        outs.println("\n]");
        outs.flush();
        scanner.close();
    }

    public static void export(Descriptor desc, PrintStream outs, String[] excludes) throws IOException {
        SSTableExport.export(SSTableReader.open(desc), outs, excludes);
    }

    public static void export(Descriptor desc, String[] excludes) throws IOException {
        SSTableExport.export(desc, System.out, excludes);
    }

    public static void main(String[] args) throws IOException, ConfigurationException {
        String usage = String.format("Usage: %s <sstable> [-k key [-k key [...]] -x key [-x key [...]]]%n", SSTableExport.class.getName());
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e1) {
            System.err.println(e1.getMessage());
            System.err.println(usage);
            System.exit(1);
        }
        if (cmd.getArgs().length != 1) {
            System.err.println("You must supply exactly one sstable");
            System.err.println(usage);
            System.exit(1);
        }
        String[] keys = cmd.getOptionValues(KEY_OPTION);
        String[] excludes = cmd.getOptionValues(EXCLUDEKEY_OPTION);
        String ssTableFileName = new File(cmd.getArgs()[0]).getAbsolutePath();
        DatabaseDescriptor.loadSchemas();
        Descriptor descriptor = Descriptor.fromFilename(ssTableFileName);
        if (Schema.instance.getCFMetaData(descriptor) == null) {
            System.err.println(String.format("The provided column family is not part of this cassandra database: keysapce = %s, column family = %s", descriptor.ksname, descriptor.cfname));
            System.exit(1);
        }
        if (cmd.hasOption(ENUMERATEKEYS_OPTION)) {
            SSTableExport.enumeratekeys(descriptor, System.out);
        } else if (keys != null && keys.length > 0) {
            SSTableExport.export(descriptor, System.out, Arrays.asList(keys), excludes);
        } else {
            SSTableExport.export(descriptor, excludes);
        }
        System.exit(0);
    }

    private static void writeJSON(PrintStream out, Object value) {
        try {
            jsonMapper.writeValue((OutputStream)out, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        Option optKey = new Option(KEY_OPTION, true, "Row key");
        optKey.setArgs(500);
        options.addOption(optKey);
        Option excludeKey = new Option(EXCLUDEKEY_OPTION, true, "Excluded row key");
        excludeKey.setArgs(500);
        options.addOption(excludeKey);
        Option optEnumerate = new Option(ENUMERATEKEYS_OPTION, false, "enumerate keys only");
        options.addOption(optEnumerate);
        jsonMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
    }
}

