/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.PermissionDetails;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;

public abstract class LegacyAuthorizer
implements IAuthorizer {
    public abstract EnumSet<Permission> authorize(AuthenticatedUser var1, List<Object> var2);

    @Override
    public abstract void validateConfiguration() throws ConfigurationException;

    @Override
    public Set<Permission> authorize(AuthenticatedUser user, IResource resource) {
        EnumSet<Permission> permissions;
        if (!(resource instanceof DataResource)) {
            throw new IllegalArgumentException(String.format("%s resource is not supported by LegacyAuthorizer", resource.getName()));
        }
        DataResource dr = (DataResource)resource;
        ArrayList<Object> legacyResource = new ArrayList<Object>();
        legacyResource.add("cassandra");
        legacyResource.add("keyspaces");
        if (!dr.isRootLevel()) {
            legacyResource.add(dr.getKeyspace());
        }
        if (dr.isColumnFamilyLevel()) {
            legacyResource.add(dr.getColumnFamily());
        }
        if ((permissions = this.authorize(user, legacyResource)).contains((Object)Permission.READ)) {
            permissions.add(Permission.SELECT);
        }
        if (permissions.contains((Object)Permission.WRITE)) {
            permissions.addAll(EnumSet.of(Permission.CREATE, Permission.ALTER, Permission.DROP, Permission.MODIFY));
        }
        return permissions;
    }

    @Override
    public void grant(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, String to) throws InvalidRequestException {
        throw new InvalidRequestException("GRANT operation is not supported by LegacyAuthorizer");
    }

    @Override
    public void revoke(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, String from) throws InvalidRequestException {
        throw new InvalidRequestException("REVOKE operation is not supported by LegacyAuthorizer");
    }

    @Override
    public void revokeAll(String droppedUser) {
    }

    @Override
    public void revokeAll(IResource droppedResource) {
    }

    @Override
    public Set<PermissionDetails> list(AuthenticatedUser performer, Set<Permission> permissions, IResource resource, String of) throws InvalidRequestException, UnauthorizedException {
        throw new InvalidRequestException("LIST PERMISSIONS operation is not supported by LegacyAuthorizer");
    }

    public Set<IResource> protectedResources() {
        return Collections.emptySet();
    }

    @Override
    public void setup() {
    }
}

