/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.Token;

public class LocalToken
extends Token<ByteBuffer> {
    static final long serialVersionUID = 8437543776403014875L;
    private final AbstractType<?> comparator;

    public LocalToken(AbstractType<?> comparator, ByteBuffer token) {
        super(token);
        this.comparator = comparator;
    }

    @Override
    public String toString() {
        return this.comparator.getString((ByteBuffer)this.token);
    }

    @Override
    public int compareTo(Token<ByteBuffer> o) {
        return this.comparator.compare(this.token, o.token);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return 31 + ((ByteBuffer)this.token).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LocalToken)) {
            return false;
        }
        LocalToken other = (LocalToken)obj;
        return ((ByteBuffer)this.token).equals(other.token);
    }
}

