/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.AbstractWriteResponseHandler;

public class DatacenterSyncWriteResponseHandler
extends AbstractWriteResponseHandler {
    private static final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
    private final NetworkTopologyStrategy strategy;
    private final HashMap<String, AtomicInteger> responses = new HashMap();
    private final AtomicInteger acks = new AtomicInteger(0);

    public DatacenterSyncWriteResponseHandler(Collection<InetAddress> naturalEndpoints, Collection<InetAddress> pendingEndpoints, ConsistencyLevel consistencyLevel, Table table, Runnable callback, WriteType writeType) {
        super(table, naturalEndpoints, pendingEndpoints, consistencyLevel, callback, writeType);
        assert (consistencyLevel == ConsistencyLevel.EACH_QUORUM);
        this.strategy = (NetworkTopologyStrategy)table.getReplicationStrategy();
        for (String dc : this.strategy.getDatacenters()) {
            int rf = this.strategy.getReplicationFactor(dc);
            this.responses.put(dc, new AtomicInteger(rf / 2 + 1));
        }
        for (InetAddress pending : pendingEndpoints) {
            this.responses.get(snitch.getDatacenter(pending)).incrementAndGet();
        }
    }

    @Override
    public void response(MessageIn message) {
        String dataCenter = message == null ? DatabaseDescriptor.getLocalDataCenter() : snitch.getDatacenter(message.from);
        this.responses.get(dataCenter).getAndDecrement();
        this.acks.incrementAndGet();
        for (AtomicInteger i : this.responses.values()) {
            if (i.get() <= 0) continue;
            return;
        }
        this.signal();
    }

    @Override
    protected int ackCount() {
        return this.acks.get();
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }
}

