/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.AbstractJdbcType;
import org.apache.cassandra.utils.ByteBufferUtil;

public class JdbcInetAddress
extends AbstractJdbcType<InetAddress> {
    public static final JdbcInetAddress instance = new JdbcInetAddress();

    JdbcInetAddress() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(InetAddress obj) {
        return 0;
    }

    @Override
    public int getPrecision(InetAddress obj) {
        return obj.toString().length();
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String toString(InetAddress obj) {
        return obj.getHostAddress();
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return this.compose(bytes).getHostAddress();
    }

    @Override
    public Class<InetAddress> getType() {
        return InetAddress.class;
    }

    @Override
    public int getJdbcType() {
        return 1111;
    }

    @Override
    public InetAddress compose(ByteBuffer bytes) {
        try {
            return InetAddress.getByAddress(ByteBufferUtil.getArray(bytes));
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ByteBuffer decompose(InetAddress value) {
        return ByteBuffer.wrap(value.getAddress());
    }
}

