/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.PerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositesSearcher
extends SecondaryIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(CompositesSearcher.class);
    private final int prefixSize;

    public CompositesSearcher(SecondaryIndexManager indexManager, Set<ByteBuffer> columns, int prefixSize) {
        super(indexManager, columns);
        this.prefixSize = prefixSize;
    }

    private IndexExpression highestSelectivityPredicate(List<IndexExpression> clause) {
        IndexExpression best = null;
        int bestMeanCount = Integer.MAX_VALUE;
        HashMap<SecondaryIndex, Integer> candidates = new HashMap<SecondaryIndex, Integer>();
        for (IndexExpression expression : clause) {
            SecondaryIndex index;
            if (!this.columns.contains(expression.column_name) || (index = this.indexManager.getIndexForColumn(expression.column_name)) == null || index.getIndexCfs() == null || expression.op != IndexOperator.EQ) continue;
            int columns = index.getIndexCfs().getMeanColumns();
            candidates.put(index, columns);
            if (columns >= bestMeanCount) continue;
            best = expression;
            bestMeanCount = columns;
        }
        if (best == null) {
            Tracing.trace("No applicable indexes found");
        } else {
            Tracing.trace("Candidate index mean cardinalities are {}. Scanning with {}.", FBUtilities.toString(candidates), this.indexManager.getIndexForColumn(best.column_name).getIndexName());
        }
        return best;
    }

    @Override
    public boolean isIndexing(List<IndexExpression> clause) {
        return this.highestSelectivityPredicate(clause) != null;
    }

    @Override
    public List<Row> search(List<IndexExpression> clause, AbstractBounds<RowPosition> range, int maxResults, IDiskAtomFilter dataFilter, boolean countCQL3Rows) {
        assert (clause != null && !clause.isEmpty());
        ExtendedFilter filter = ExtendedFilter.create(this.baseCfs, dataFilter, clause, maxResults, countCQL3Rows, false);
        return this.baseCfs.filter(this.getIndexedIterator(range, filter), filter);
    }

    public ColumnFamilyStore.AbstractScanIterator getIndexedIterator(final AbstractBounds<RowPosition> range, final ExtendedFilter filter) {
        SliceQueryFilter originalFilter;
        ByteBuffer endPrefix;
        ByteBuffer startPrefix;
        final IndexExpression primary = this.highestSelectivityPredicate(filter.getClause());
        final SecondaryIndex index = this.indexManager.getIndexForColumn(primary.column_name);
        assert (index != null);
        assert (index.getIndexCfs() != null);
        final DecoratedKey indexKey = index.getIndexKeyFor(primary.value);
        if (logger.isDebugEnabled()) {
            logger.debug("Most-selective indexed predicate is {}", (Object)((AbstractSimplePerColumnSecondaryIndex)index).expressionString(primary));
        }
        ByteBuffer startKey = range.left instanceof DecoratedKey ? ((DecoratedKey)range.left).key : ByteBufferUtil.EMPTY_BYTE_BUFFER;
        ByteBuffer endKey = range.right instanceof DecoratedKey ? ((DecoratedKey)range.right).key : ByteBufferUtil.EMPTY_BYTE_BUFFER;
        final CompositeType baseComparator = (CompositeType)this.baseCfs.getComparator();
        final CompositeType indexComparator = (CompositeType)index.getIndexCfs().getComparator();
        if (startKey.remaining() > 0) {
            CompositeType.Builder builder = indexComparator.builder().add(startKey);
            if (filter.originalFilter() instanceof SliceQueryFilter) {
                ByteBuffer[] components = baseComparator.split(((SliceQueryFilter)filter.originalFilter()).start());
                for (int i = 0; i < Math.min(this.prefixSize, components.length); ++i) {
                    builder.add(components[i]);
                }
            }
            startPrefix = builder.build();
        } else {
            startPrefix = ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        if (endKey.remaining() > 0) {
            CompositeType.Builder builder = indexComparator.builder().add(endKey);
            if (filter.originalFilter() instanceof SliceQueryFilter) {
                ByteBuffer[] components = baseComparator.split(((SliceQueryFilter)filter.originalFilter()).finish());
                for (int i = 0; i < Math.min(this.prefixSize, components.length); ++i) {
                    builder.add(components[i]);
                }
            }
            endPrefix = builder.buildAsEndOfRange();
        } else {
            endPrefix = ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        if (filter.originalFilter() instanceof SliceQueryFilter) {
            originalFilter = (SliceQueryFilter)filter.originalFilter();
        } else {
            ByteBuffer first = (ByteBuffer)((NamesQueryFilter)filter.originalFilter()).columns.iterator().next();
            ByteBuffer[] components = baseComparator.split(first);
            CompositeType.Builder builder = baseComparator.builder();
            for (int i = 0; i < components.length - 1; ++i) {
                builder.add(components[i]);
            }
            originalFilter = new SliceQueryFilter(builder.copy().build(), builder.copy().buildAsEndOfRange(), false, Integer.MAX_VALUE);
        }
        return new ColumnFamilyStore.AbstractScanIterator(){
            private ByteBuffer lastSeenPrefix;
            private ArrayDeque<IColumn> indexColumns;
            private final QueryPath path;
            private int columnsRead;
            private int limit;
            private int columnsCount;
            private int meanColumns;
            private final int rowsPerQuery;
            {
                this.lastSeenPrefix = startPrefix;
                this.path = new QueryPath(((CompositesSearcher)CompositesSearcher.this).baseCfs.columnFamily);
                this.columnsRead = Integer.MAX_VALUE;
                this.limit = ((SliceQueryFilter)filter.initialFilter()).count;
                this.columnsCount = 0;
                this.meanColumns = Math.max(index.getIndexCfs().getMeanColumns(), 1);
                this.rowsPerQuery = Math.max(Math.min(filter.maxRows(), filter.maxColumns() / this.meanColumns), 2);
            }

            @Override
            public boolean needsFiltering() {
                return false;
            }

            private Row makeReturn(DecoratedKey key, ColumnFamily data) {
                if (data == null) {
                    return (Row)this.endOfData();
                }
                assert (key != null);
                return new Row(key, data);
            }

            protected Row computeNext() {
                DecoratedKey currentKey = null;
                ColumnFamily data = null;
                block0: while (this.columnsCount < this.limit) {
                    if (this.indexColumns == null || this.indexColumns.isEmpty()) {
                        if (this.columnsRead < this.rowsPerQuery) {
                            logger.trace("Read only {} (< {}) last page through, must be done", (Object)this.columnsRead, (Object)this.rowsPerQuery);
                            return this.makeReturn(currentKey, data);
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace("Scanning index {} starting with {}", (Object)((AbstractSimplePerColumnSecondaryIndex)index).expressionString(primary), (Object)indexComparator.getString(startPrefix));
                        }
                        QueryFilter indexFilter = QueryFilter.getSliceFilter(indexKey, new QueryPath(index.getIndexCfs().getColumnFamilyName()), this.lastSeenPrefix, endPrefix, false, this.rowsPerQuery);
                        ColumnFamily indexRow = index.getIndexCfs().getColumnFamily(indexFilter);
                        if (indexRow == null) {
                            return this.makeReturn(currentKey, data);
                        }
                        Collection<IColumn> sortedColumns = indexRow.getSortedColumns();
                        this.columnsRead = sortedColumns.size();
                        this.indexColumns = new ArrayDeque<IColumn>(sortedColumns);
                        IColumn firstColumn = sortedColumns.iterator().next();
                        if (this.lastSeenPrefix != startPrefix && this.lastSeenPrefix.equals(firstColumn.name())) {
                            this.indexColumns.poll();
                            logger.trace("Skipping {}", (Object)indexComparator.getString(firstColumn.name()));
                        } else if (range instanceof Range && !this.indexColumns.isEmpty() && firstColumn.name().equals(startPrefix)) {
                            this.indexColumns.poll();
                            logger.trace("Skipping first key as range excludes it");
                        }
                    }
                    while (true) {
                        ByteBuffer indexedValue;
                        if (this.indexColumns.isEmpty() || this.columnsCount > this.limit) continue block0;
                        IColumn column = this.indexColumns.poll();
                        this.lastSeenPrefix = column.name();
                        if (column.isMarkedForDelete()) {
                            logger.trace("skipping {}", (Object)column.name());
                            continue;
                        }
                        ByteBuffer[] components = indexComparator.split(this.lastSeenPrefix);
                        DecoratedKey dk = ((CompositesSearcher)CompositesSearcher.this).baseCfs.partitioner.decorateKey(components[0]);
                        if (currentKey == null) {
                            currentKey = dk;
                        } else if (!currentKey.equals(dk)) {
                            DecoratedKey previousKey = currentKey;
                            currentKey = dk;
                            this.indexColumns.addFirst(column);
                            if (data == null) continue;
                            return this.makeReturn(previousKey, data);
                        }
                        if (!((RowPosition)range.right).isMinimum(((CompositesSearcher)CompositesSearcher.this).baseCfs.partitioner) && ((RowPosition)range.right).compareTo(dk) < 0) {
                            logger.trace("Reached end of assigned scan range");
                            return (Row)this.endOfData();
                        }
                        if (!range.contains(dk)) {
                            logger.debug("Skipping entry {} outside of assigned scan range", (Object)dk.token);
                            continue;
                        }
                        logger.trace("Adding index hit to current row for {}", (Object)indexComparator.getString(this.lastSeenPrefix));
                        CompositeType.Builder builder = baseComparator.builder();
                        for (int i = 0; i < CompositesSearcher.this.prefixSize; ++i) {
                            builder.add(components[i + 1]);
                        }
                        ByteBuffer start = builder.copy().build();
                        if (!originalFilter.includes(baseComparator, start)) continue;
                        SliceQueryFilter dataFilter = new SliceQueryFilter(start, builder.copy().buildAsEndOfRange(), false, Integer.MAX_VALUE, CompositesSearcher.this.prefixSize);
                        ColumnFamily newData = CompositesSearcher.this.baseCfs.getColumnFamily(new QueryFilter(dk, this.path, dataFilter));
                        if (newData == null) continue;
                        ByteBuffer baseColumnName = builder.copy().add(primary.column_name).build();
                        if (CompositesSearcher.this.isIndexValueStale(newData, baseColumnName, indexedValue = indexKey.key)) {
                            Column dummyColumn = new Column(baseColumnName, indexedValue, column.timestamp());
                            ((PerColumnSecondaryIndex)index).delete(dk.key, dummyColumn);
                            continue;
                        }
                        if (!filter.isSatisfiedBy(newData, builder)) continue;
                        if (data == null) {
                            data = ColumnFamily.create(((CompositesSearcher)CompositesSearcher.this).baseCfs.metadata);
                        }
                        data.resolve(newData);
                        this.columnsCount += dataFilter.lastCounted();
                    }
                    break;
                }
                return this.makeReturn(currentKey, data);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

