/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.net.OutboundTcpConnectionPool;

public class ConnectionMetrics {
    public static final String TYPE_NAME = "Connection";
    public static final Meter totalTimeouts = Metrics.newMeter((MetricName)DefaultNameFactory.createMetricName("Connection", "TotalTimeouts", null), (String)"total timeouts", (TimeUnit)TimeUnit.SECONDS);
    private static long recentTimeouts;
    public final String address;
    public final Gauge<Integer> commandPendingTasks;
    public final Gauge<Long> commandCompletedTasks;
    public final Gauge<Long> commandDroppedTasks;
    public final Gauge<Integer> responsePendingTasks;
    public final Gauge<Long> responseCompletedTasks;
    public final Meter timeouts;
    private final MetricNameFactory factory;
    private long recentTimeoutCount;

    public ConnectionMetrics(InetAddress ip, final OutboundTcpConnectionPool connectionPool) {
        this.address = ip.getHostAddress().replaceAll(":", ".");
        this.factory = new DefaultNameFactory(TYPE_NAME, this.address);
        this.commandPendingTasks = Metrics.newGauge((MetricName)this.factory.createMetricName("CommandPendingTasks"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return connectionPool.cmdCon.getPendingMessages();
            }
        });
        this.commandCompletedTasks = Metrics.newGauge((MetricName)this.factory.createMetricName("CommandCompletedTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return connectionPool.cmdCon.getCompletedMesssages();
            }
        });
        this.commandDroppedTasks = Metrics.newGauge((MetricName)this.factory.createMetricName("CommandDroppedTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return connectionPool.cmdCon.getDroppedMessages();
            }
        });
        this.responsePendingTasks = Metrics.newGauge((MetricName)this.factory.createMetricName("ResponsePendingTasks"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return connectionPool.ackCon.getPendingMessages();
            }
        });
        this.responseCompletedTasks = Metrics.newGauge((MetricName)this.factory.createMetricName("ResponseCompletedTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return connectionPool.ackCon.getCompletedMesssages();
            }
        });
        this.timeouts = Metrics.newMeter((MetricName)this.factory.createMetricName("Timeouts"), (String)"timeouts", (TimeUnit)TimeUnit.SECONDS);
    }

    public void release() {
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CommandPendingTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CommandCompletedTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CommandDroppedTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("ResponsePendingTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("ResponseCompletedTasks"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("Timeouts"));
    }

    @Deprecated
    public static long getRecentTotalTimeout() {
        long total = totalTimeouts.count();
        long recent = total - recentTimeouts;
        recentTimeouts = total;
        return recent;
    }

    @Deprecated
    public long getRecentTimeout() {
        long timeoutCount = this.timeouts.count();
        long recent = timeoutCount - this.recentTimeoutCount;
        this.recentTimeoutCount = timeoutCount;
        return recent;
    }
}

