/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.MeteredFlusher;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.GCInspector;
import org.apache.cassandra.service.NativeAccessMBean;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.ThriftServer;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.Mx4jTool;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemon {
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=NativeAccess";
    private static final Thread exitThread;
    private static final Logger logger;
    private static final CassandraDaemon instance;
    public Server thriftServer;
    public Server nativeServer;

    public static void initLog4j() {
        if (System.getProperty("log4j.defaultInitOverride", "false").equalsIgnoreCase("true")) {
            String config = System.getProperty("log4j.configuration", "log4j-server.properties");
            URL configLocation = null;
            try {
                configLocation = new URL(config);
            }
            catch (MalformedURLException ex) {
                configLocation = CassandraDaemon.class.getClassLoader().getResource(config);
            }
            if (configLocation == null) {
                throw new RuntimeException("Couldn't figure out log4j configuration: " + config);
            }
            String configFileName = null;
            try {
                configFileName = configLocation.getFile();
                File configFile = new File(configFileName);
                if (!configFile.exists()) {
                    configFileName = new File(configLocation.toURI()).getPath();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't convert log4j configuration location to a valid file", e);
            }
            PropertyConfigurator.configureAndWatch((String)configFileName, (long)10000L);
            org.apache.log4j.Logger.getLogger(CassandraDaemon.class).info((Object)"Logging initialized");
        }
    }

    protected void setup() {
        if (!System.getProperty("os.arch").contains("64")) {
            logger.info("32bit JVM detected.  It is recommended to run Cassandra on a 64bit JVM for better performance.");
        }
        String javaVersion = System.getProperty("java.version");
        String javaVmName = System.getProperty("java.vm.name");
        logger.info("JVM vendor/version: {}/{}", (Object)javaVmName, (Object)javaVersion);
        if (!javaVmName.contains("OpenJDK")) {
            if (!javaVmName.contains("HotSpot")) {
                logger.warn("Non-Oracle JVM detected.  Some features, such as immediate unmap of compacted SSTables, may not work as intended");
            } else {
                int java_minor;
                Object[] java_version = javaVersion.split("_");
                String java_major = java_version[0];
                try {
                    java_minor = java_version.length > 1 ? Integer.parseInt((String)java_version[1]) : 0;
                }
                catch (NumberFormatException e) {
                    logger.info("Unable to parse java version {}", (Object)Arrays.toString(java_version));
                    java_minor = 32;
                }
                if (java_major.equals("1.6.0")) {
                    if (java_minor < 29) {
                        logger.error("Your JVM is out of date. Please upgrade to the newest Oracle Java 6.");
                    } else if (java_minor < 32) {
                        logger.warn("Your JVM is out of date. Please upgrade to the newest Oracle Java 6.");
                    }
                }
            }
        }
        logger.info("Heap size: {}/{}", (Object)Runtime.getRuntime().totalMemory(), (Object)Runtime.getRuntime().maxMemory());
        logger.info("Classpath: {}", (Object)System.getProperty("java.class.path"));
        CLibrary.tryMlockall();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void uncaughtException(Thread t, Throwable e) {
                StorageMetrics.exceptions.inc();
                logger.error("Exception in thread " + t, e);
                Tracing.trace("Exception in thread " + t, e);
                for (Throwable e2 = e; e2 != null; e2 = e2.getCause()) {
                    if (e2 instanceof OutOfMemoryError) {
                        Thread thread = exitThread;
                        synchronized (thread) {
                            if (!exitThread.isAlive()) {
                                exitThread.start();
                            }
                        }
                    }
                    if (!(e2 instanceof FSError)) continue;
                    if (e2 != e) {
                        logger.error("Exception in thread " + t, e2);
                    }
                    FileUtils.handleFSError((FSError)e2);
                }
            }
        });
        Iterable dirs = Iterables.concat(Arrays.asList(DatabaseDescriptor.getAllDataFileLocations()), Arrays.asList(DatabaseDescriptor.getCommitLogLocation(), DatabaseDescriptor.getSavedCachesLocation()));
        for (String dataDir : dirs) {
            logger.debug("Checking directory {}", (Object)dataDir);
            File dir = new File(dataDir);
            if (dir.exists()) assert (dir.isDirectory() && dir.canRead() && dir.canWrite() && dir.canExecute()) : String.format("Directory %s is not accessible.", dataDir);
        }
        if (Directories.sstablesNeedsMigration()) {
            Directories.migrateSSTables();
        }
        if (CacheService.instance == null) {
            throw new RuntimeException("Failed to initialize Cache Service.");
        }
        for (CFMetaData cfm : Schema.instance.getTableMetaData("system").values()) {
            ColumnFamilyStore.scrubDataDirectories("system", cfm.cfName);
        }
        try {
            SystemTable.checkHealth();
        }
        catch (ConfigurationException e) {
            logger.error("Fatal exception during initialization", (Throwable)e);
            System.exit(100);
        }
        try {
            DatabaseDescriptor.loadSchemas();
        }
        catch (IOException e) {
            logger.error("Fatal exception during initialization", (Throwable)e);
            System.exit(100);
        }
        for (String table : Schema.instance.getTables()) {
            for (CFMetaData cfm : Schema.instance.getTableMetaData(table).values()) {
                ColumnFamilyStore.scrubDataDirectories(table, cfm.cfName);
            }
        }
        for (String table : Schema.instance.getTables()) {
            if (logger.isDebugEnabled()) {
                logger.debug("opening keyspace " + table);
            }
            for (ColumnFamilyStore cfs : Table.open(table).getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    store.disableAutoCompaction();
                }
            }
        }
        if (CacheService.instance.keyCache.size() > 0) {
            logger.info("completed pre-loading ({} keys) key cache.", (Object)CacheService.instance.keyCache.size());
        }
        if (CacheService.instance.rowCache.size() > 0) {
            logger.info("completed pre-loading ({} keys) row cache.", (Object)CacheService.instance.rowCache.size());
        }
        try {
            GCInspector.instance.start();
        }
        catch (Throwable t) {
            logger.warn("Unable to start GCInspector (currently only supported on the Sun JVM)");
        }
        StorageService.optionalTasks.scheduleWithFixedDelay(new MeteredFlusher(), 1000L, 1000L, TimeUnit.MILLISECONDS);
        try {
            CommitLog.instance.recover();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Table table : Table.all()) {
            for (ColumnFamilyStore cfs : table.getColumnFamilyStores()) {
                for (ColumnFamilyStore store : cfs.concatWithIndexes()) {
                    store.enableAutoCompaction();
                }
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (Table table : Table.all()) {
                    for (ColumnFamilyStore cf : table.getColumnFamilyStores()) {
                        for (ColumnFamilyStore store : cf.concatWithIndexes()) {
                            CompactionManager.instance.submitBackground(store);
                        }
                    }
                }
            }
        };
        StorageService.optionalTasks.schedule(runnable, 300L, TimeUnit.SECONDS);
        SystemTable.finishStartup();
        StorageService.instance.registerDaemon(this);
        try {
            StorageService.instance.initServer();
        }
        catch (ConfigurationException e) {
            logger.error("Fatal configuration error", (Throwable)e);
            System.err.println(e.getMessage() + "\nFatal configuration error; unable to start server.  See log for stacktrace.");
            System.exit(1);
        }
        Mx4jTool.maybeLoad();
        InetAddress rpcAddr = DatabaseDescriptor.getRpcAddress();
        int rpcPort = DatabaseDescriptor.getRpcPort();
        this.thriftServer = new ThriftServer(rpcAddr, rpcPort);
        InetAddress nativeAddr = DatabaseDescriptor.getNativeTransportAddress();
        int nativePort = DatabaseDescriptor.getNativeTransportPort();
        this.nativeServer = new org.apache.cassandra.transport.Server(nativeAddr, nativePort);
    }

    public void init(String[] arguments) throws IOException {
        this.setup();
    }

    public void start() {
        String nativeFlag = System.getProperty("cassandra.start_native_transport");
        if (nativeFlag != null && Boolean.parseBoolean(nativeFlag) || nativeFlag == null && DatabaseDescriptor.startNativeTransport()) {
            this.nativeServer.start();
        } else {
            logger.info("Not starting native transport as requested. Use JMX (StorageService->startNativeTransport()) or nodetool (enablebinary) to start it");
        }
        String rpcFlag = System.getProperty("cassandra.start_rpc");
        if (rpcFlag != null && Boolean.parseBoolean(rpcFlag) || rpcFlag == null && DatabaseDescriptor.startRpc()) {
            this.thriftServer.start();
        } else {
            logger.info("Not starting RPC server as requested. Use JMX (StorageService->startRPCServer()) or nodetool (enablethrift) to start it");
        }
    }

    public void stop() {
        logger.info("Cassandra shutting down...");
        this.thriftServer.stop();
        this.nativeServer.stop();
    }

    public void destroy() {
    }

    public void activate() {
        String pidFile = System.getProperty("cassandra-pidfile");
        try {
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                mbs.registerMBean(new StandardMBean(new NativeAccess(), NativeAccessMBean.class), new ObjectName(MBEAN_NAME));
            }
            catch (Exception e) {
                logger.error("error registering MBean org.apache.cassandra.db:type=NativeAccess", (Throwable)e);
            }
            this.setup();
            if (pidFile != null) {
                new File(pidFile).deleteOnExit();
            }
            if (System.getProperty("cassandra-foreground") == null) {
                System.out.close();
                System.err.close();
            }
            this.start();
        }
        catch (Throwable e) {
            logger.error("Exception encountered during startup", e);
            e.printStackTrace();
            System.out.println("Exception encountered during startup: " + e.getMessage());
            System.exit(3);
        }
    }

    public void deactivate() {
        this.stop();
        this.destroy();
    }

    public static void stop(String[] args) {
        instance.deactivate();
    }

    public static void main(String[] args) {
        instance.activate();
    }

    static {
        CassandraDaemon.initLog4j();
        exitThread = new Thread(new Runnable(){

            @Override
            public void run() {
                System.exit(100);
            }
        }, "Exit invoker");
        logger = LoggerFactory.getLogger(CassandraDaemon.class);
        instance = new CassandraDaemon();
    }

    public static interface Server {
        public void start();

        public void stop();

        public boolean isRunning();
    }

    static class NativeAccess
    implements NativeAccessMBean {
        NativeAccess() {
        }

        @Override
        public boolean isAvailable() {
            return CLibrary.jnaAvailable();
        }

        @Override
        public boolean isMemoryLockable() {
            return CLibrary.jnaMemoryLockable();
        }
    }
}

