/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.project.ConfigurationSaver;
import org.apache.cayenne.project.ConfigurationSourceGetter;
import org.apache.cayenne.project.ConfigurationSourceSetter;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.project.SaveableNodesGetter;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.URLResource;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileProjectSaver
implements ProjectSaver {
    @Inject
    protected ConfigurationNameMapper nameMapper;
    protected ConfigurationNodeVisitor<Resource> resourceGetter = new ConfigurationSourceGetter();
    protected ConfigurationNodeVisitor<Collection<ConfigurationNode>> saveableNodesGetter = new SaveableNodesGetter();
    protected String fileEncoding = "UTF-8";

    @Override
    public String getSupportedVersion() {
        return "6";
    }

    @Override
    public void save(Project project) {
        Collection nodes = (Collection)project.getRootNode().acceptVisitor(this.saveableNodesGetter);
        ArrayList<SaveUnit> saveUnits = new ArrayList<SaveUnit>(nodes.size());
        for (ConfigurationNode node : nodes) {
            saveUnits.add(this.createSaveUnit(node, null));
        }
        this.save(saveUnits, true);
    }

    @Override
    public void saveAs(Project project, Resource baseDirectory) {
        if (baseDirectory == null) {
            throw new NullPointerException("Null 'baseDirectory'");
        }
        Collection nodes = (Collection)project.getRootNode().acceptVisitor(this.saveableNodesGetter);
        ArrayList<SaveUnit> saveUnits = new ArrayList<SaveUnit>(nodes.size());
        for (ConfigurationNode node : nodes) {
            saveUnits.add(this.createSaveUnit(node, baseDirectory));
        }
        this.save(saveUnits, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(Collection<SaveUnit> units, boolean deleteOldResources) {
        this.checkAccess(units);
        try {
            this.saveToTempFiles(units);
            this.saveCommit(units);
        }
        finally {
            this.clearTempFiles(units);
        }
        if (deleteOldResources) {
            this.clearOldFiles(units);
        }
    }

    SaveUnit createSaveUnit(ConfigurationNode node, Resource baseResource) {
        SaveUnit unit = new SaveUnit();
        unit.node = node;
        unit.sourceConfiguration = (Resource)node.acceptVisitor(this.resourceGetter);
        if (baseResource == null) {
            baseResource = unit.sourceConfiguration;
        }
        String targetLocation = this.nameMapper.configurationLocation(node);
        Resource targetResource = baseResource.getRelativeResource(targetLocation);
        URL targetUrl = targetResource.getURL();
        try {
            unit.targetFile = Util.toFile((URL)targetUrl);
        }
        catch (IllegalArgumentException e) {
            throw new CayenneRuntimeException("Can't save configuration to the following location: '%s'. Is this a valid file location?. (%s)", (Throwable)e, new Object[]{targetUrl, e.getMessage()});
        }
        return unit;
    }

    void checkAccess(Collection<SaveUnit> units) {
        for (SaveUnit unit : units) {
            File targetFile = unit.targetFile;
            File parent = targetFile.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new CayenneRuntimeException("Error creating directory tree for '%s'", new Object[]{parent.getAbsolutePath()});
            }
            if (targetFile.isDirectory()) {
                throw new CayenneRuntimeException("Target file '%s' is a directory", new Object[]{targetFile.getAbsolutePath()});
            }
            if (!targetFile.exists() || targetFile.canWrite()) continue;
            throw new CayenneRuntimeException("Can't write to file '%s'", new Object[]{targetFile.getAbsolutePath()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveToTempFiles(Collection<SaveUnit> units) {
        for (SaveUnit unit : units) {
            PrintWriter printWriter;
            String name = unit.targetFile.getName();
            if (name == null || name.length() < 3) {
                name = "cayenne-project";
            }
            File parent = unit.targetFile.getParentFile();
            try {
                unit.targetTempFile = File.createTempFile(name, null, parent);
            }
            catch (IOException e) {
                throw new CayenneRuntimeException("Error creating temp file (%s)", (Throwable)e, new Object[]{e.getMessage()});
            }
            if (unit.targetTempFile.exists()) {
                unit.targetTempFile.delete();
            }
            try {
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(unit.targetTempFile), this.fileEncoding));
            }
            catch (UnsupportedEncodingException e) {
                throw new CayenneRuntimeException("Unsupported encoding '%s' (%s)", (Throwable)e, new Object[]{this.fileEncoding, e.getMessage()});
            }
            catch (FileNotFoundException e) {
                throw new CayenneRuntimeException("File not found '%s' (%s)", (Throwable)e, new Object[]{unit.targetTempFile.getAbsolutePath(), e.getMessage()});
            }
            try {
                this.saveToTempFile(unit, printWriter);
            }
            finally {
                printWriter.close();
            }
        }
    }

    void saveToTempFile(SaveUnit unit, PrintWriter printWriter) {
        unit.node.acceptVisitor((ConfigurationNodeVisitor)new ConfigurationSaver(printWriter, this.getSupportedVersion()));
    }

    void saveCommit(Collection<SaveUnit> units) {
        for (SaveUnit unit : units) {
            File targetFile = unit.targetFile;
            if (targetFile.exists() && !targetFile.delete()) {
                throw new CayenneRuntimeException("Unable to remove old master file '%s'", new Object[]{targetFile.getAbsolutePath()});
            }
            File tempFile = unit.targetTempFile;
            if (!tempFile.renameTo(targetFile)) {
                throw new CayenneRuntimeException("Unable to move '%s' to '%s'", new Object[]{tempFile.getAbsolutePath(), targetFile.getAbsolutePath()});
            }
            unit.targetTempFile = null;
            try {
                unit.node.acceptVisitor((ConfigurationNodeVisitor)new ConfigurationSourceSetter((Resource)new URLResource(targetFile.toURL())));
            }
            catch (MalformedURLException e) {
                throw new CayenneRuntimeException("Malformed URL for file '%s'", (Throwable)e, new Object[]{targetFile.getAbsolutePath()});
            }
        }
    }

    void clearTempFiles(Collection<SaveUnit> units) {
        for (SaveUnit unit : units) {
            if (unit.targetTempFile == null || !unit.targetTempFile.exists()) continue;
            unit.targetTempFile.delete();
            unit.targetTempFile = null;
        }
    }

    private void clearOldFiles(Collection<SaveUnit> units) {
        for (SaveUnit unit : units) {
            File sourceFile;
            if (unit.sourceConfiguration == null) continue;
            URL sourceUrl = unit.sourceConfiguration.getURL();
            try {
                sourceFile = Util.toFile((URL)sourceUrl);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (!sourceFile.exists()) continue;
            boolean isTarget = false;
            for (SaveUnit xunit : units) {
                if (!sourceFile.equals(xunit.targetFile)) continue;
                isTarget = true;
                break;
            }
            if (isTarget) continue;
            sourceFile.delete();
        }
    }

    class SaveUnit {
        private ConfigurationNode node;
        private Resource sourceConfiguration;
        private File targetFile;
        private File targetTempFile;

        SaveUnit() {
        }
    }
}

