/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;

public class PropertyDataSourceFactory
implements DataSourceFactory {
    static final String JDBC_DRIVER_PROPERTY = "cayenne.jdbc.driver";
    static final String JDBC_URL_PROPERTY = "cayenne.jdbc.url";
    static final String JDBC_USERNAME_PROPERTY = "cayenne.jdbc.username";
    static final String JDBC_PASSWORD_PROPERTY = "cayenne.jdbc.password";
    static final String JDBC_MIN_CONNECTIONS_PROPERTY = "cayenne.jdbc.min.connections";
    static final String JDBC_MAX_CONNECTIONS_PROPERTY = "cayenne.jdbc.max.conections";
    @Inject
    protected RuntimeProperties properties;
    @Inject
    protected JdbcEventLogger jdbcEventLogger;

    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        String suffix = "." + nodeDescriptor.getDataChannelDescriptor().getName() + "." + nodeDescriptor.getName();
        String driver = this.getProperty(JDBC_DRIVER_PROPERTY, suffix);
        String url = this.getProperty(JDBC_URL_PROPERTY, suffix);
        String username = this.getProperty(JDBC_USERNAME_PROPERTY, suffix);
        String password = this.getProperty(JDBC_PASSWORD_PROPERTY, suffix);
        int minConnections = this.getIntProperty(JDBC_MIN_CONNECTIONS_PROPERTY, suffix, 1);
        int maxConnections = this.getIntProperty(JDBC_MAX_CONNECTIONS_PROPERTY, suffix, 1);
        try {
            return new PoolManager(driver, url, minConnections, maxConnections, username, password, this.jdbcEventLogger);
        }
        catch (Exception e) {
            this.jdbcEventLogger.logConnectFailure(e);
            throw e;
        }
    }

    protected int getIntProperty(String propertyName, String suffix, int defaultValue) {
        String string = this.getProperty(propertyName, suffix);
        if (string == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Invalid int property '%s': '%s'", propertyName, string);
        }
    }

    protected String getProperty(String propertyName, String suffix) {
        String value = this.properties.get(propertyName + suffix);
        return value != null ? value : this.properties.get(propertyName);
    }
}

