/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverDataSource
implements DataSource {
    protected Driver driver;
    protected String connectionUrl;
    protected String userName;
    protected String password;
    protected JdbcEventLogger logger;

    private static Driver loadDriver(String driverClassName) throws SQLException {
        Class<?> driverClass;
        try {
            driverClass = Util.getJavaClass(driverClassName);
        }
        catch (Exception ex) {
            throw new SQLException("Can not load JDBC driver named '" + driverClassName + "': " + ex.getMessage());
        }
        try {
            return (Driver)driverClass.newInstance();
        }
        catch (Exception ex) {
            throw new SQLException("Error instantiating driver '" + driverClassName + "': " + ex.getMessage());
        }
    }

    public DriverDataSource(String driverClassName, String connectionUrl) throws SQLException {
        this(driverClassName, connectionUrl, null, null);
    }

    public DriverDataSource(String driverClassName, String connectionUrl, String userName, String password) throws SQLException {
        this.setDriverClassName(driverClassName);
        this.connectionUrl = connectionUrl;
        this.userName = userName;
        this.password = password;
    }

    public DriverDataSource(Driver driver, String connectionUrl, String userName, String password) {
        this.driver = driver;
        this.connectionUrl = connectionUrl;
        this.userName = userName;
        this.password = password;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.userName, this.password);
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        try {
            if (this.logger != null) {
                this.logger.logConnect(this.connectionUrl, userName, password);
            }
            Connection c = null;
            if (this.driver == null) {
                c = DriverManager.getConnection(this.connectionUrl, userName, password);
            } else {
                Properties connectProperties = new Properties();
                if (userName != null) {
                    connectProperties.put("user", userName);
                }
                if (password != null) {
                    connectProperties.put("password", password);
                }
                c = this.driver.connect(this.connectionUrl, connectProperties);
            }
            if (c == null) {
                throw new SQLException("Can't establish connection: " + this.connectionUrl);
            }
            if (this.logger != null) {
                this.logger.logConnectSuccess();
            }
            return c;
        }
        catch (SQLException sqlex) {
            if (this.logger != null) {
                this.logger.logConnectFailure(sqlex);
            }
            throw sqlex;
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return -1;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    public JdbcEventLogger getLogger() {
        return this.logger;
    }

    public void setLogger(JdbcEventLogger delegate) {
        this.logger = delegate;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getDriverClassName() {
        return this.driver != null ? this.driver.getClass().getName() : null;
    }

    public void setDriverClassName(String driverClassName) throws SQLException {
        if (!Util.nullSafeEquals(this.getDriverClassName(), driverClassName)) {
            this.driver = driverClassName != null ? DriverDataSource.loadDriver(driverClassName) : null;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

