/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;

public class OperationContextImpl
implements OperationContext,
Serializable {
    public static final String PROPERTIES_STAR = "*";
    public static final String RENDITION_NONE = "cmis:none";
    private static final long serialVersionUID = 1L;
    private TreeSet<String> filter;
    private boolean loadSecondaryTypeProperties;
    private boolean includeAcls;
    private boolean includeAllowableActions;
    private boolean includePolicies;
    private IncludeRelationships includeRelationships;
    private TreeSet<String> renditionFilter;
    private boolean includePathSegments;
    private String orderBy;
    private boolean cacheEnabled;
    private String cacheKey;
    private int maxItemsPerPage;

    public OperationContextImpl() {
        this.setFilter(null);
        this.setLoadSecondaryTypeProperties(false);
        this.setIncludeAcls(false);
        this.setIncludeAllowableActions(true);
        this.setIncludePolicies(false);
        this.setIncludeRelationships(IncludeRelationships.NONE);
        this.setRenditionFilter(null);
        this.setIncludePathSegments(true);
        this.setOrderBy(null);
        this.setCacheEnabled(false);
        this.generateCacheKey();
        this.setMaxItemsPerPage(100);
    }

    public OperationContextImpl(OperationContext source) {
        this.setFilter(source.getFilter());
        this.setLoadSecondaryTypeProperties(source.loadSecondaryTypeProperties());
        this.setIncludeAcls(source.isIncludeAcls());
        this.setIncludeAllowableActions(source.isIncludeAllowableActions());
        this.setIncludePolicies(source.isIncludePolicies());
        this.setIncludeRelationships(source.getIncludeRelationships());
        this.setRenditionFilter(source.getRenditionFilter());
        this.setIncludePathSegments(source.isIncludePathSegments());
        this.setOrderBy(source.getOrderBy());
        this.setCacheEnabled(source.isCacheEnabled());
        this.generateCacheKey();
        this.setMaxItemsPerPage(source.getMaxItemsPerPage());
    }

    public OperationContextImpl(Set<String> propertyFilter, boolean includeAcls, boolean includeAllowableActions, boolean includePolicies, IncludeRelationships includeRelationships, Set<String> renditionFilter, boolean includePathSegments, String orderBy, boolean cacheEnabled, int maxItemsPerPage) {
        this.setFilter(propertyFilter);
        this.setIncludeAcls(includeAcls);
        this.setIncludeAllowableActions(includeAllowableActions);
        this.setIncludePolicies(includePolicies);
        this.setIncludeRelationships(includeRelationships);
        this.setRenditionFilter(renditionFilter);
        this.setIncludePathSegments(includePathSegments);
        this.setOrderBy(orderBy);
        this.setCacheEnabled(cacheEnabled);
        this.generateCacheKey();
        this.setMaxItemsPerPage(maxItemsPerPage);
    }

    public final Set<String> getFilter() {
        if (this.filter == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.filter);
    }

    public final void setFilter(Set<String> propertyFilter) {
        if (propertyFilter != null) {
            TreeSet<String> tempSet = new TreeSet<String>();
            for (String oid : propertyFilter) {
                String toid;
                if (oid == null || (toid = oid.trim()).length() == 0) continue;
                if (toid.equals(PROPERTIES_STAR)) {
                    tempSet = new TreeSet();
                    tempSet.add(PROPERTIES_STAR);
                    break;
                }
                if (toid.indexOf(44) > -1) {
                    throw new IllegalArgumentException("Query id must not contain a comma!");
                }
                tempSet.add(toid);
            }
            this.filter = tempSet.isEmpty() ? null : tempSet;
        } else {
            this.filter = null;
        }
        this.generateCacheKey();
    }

    public final void setFilterString(String propertyFilter) {
        if (propertyFilter == null || propertyFilter.trim().length() == 0) {
            this.setFilter(null);
            return;
        }
        String[] propertyIds = propertyFilter.split(",");
        TreeSet<String> tempSet = new TreeSet<String>();
        for (String pid : propertyIds) {
            tempSet.add(pid);
        }
        this.setFilter(tempSet);
    }

    public final String getFilterString() {
        if (this.filter == null) {
            return null;
        }
        if (this.filter.contains(PROPERTIES_STAR)) {
            return PROPERTIES_STAR;
        }
        this.filter.add("cmis:objectId");
        this.filter.add("cmis:baseTypeId");
        this.filter.add("cmis:objectTypeId");
        if (this.loadSecondaryTypeProperties) {
            this.filter.add("cmis:secondaryObjectTypeIds");
        }
        StringBuilder sb = new StringBuilder();
        for (String oid : this.filter) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(oid);
        }
        return sb.toString();
    }

    public final void setLoadSecondaryTypeProperties(boolean load) {
        this.loadSecondaryTypeProperties = load;
    }

    public final boolean loadSecondaryTypeProperties() {
        return this.loadSecondaryTypeProperties;
    }

    public final boolean isIncludeAcls() {
        return this.includeAcls;
    }

    public final void setIncludeAcls(boolean include) {
        this.includeAcls = include;
        this.generateCacheKey();
    }

    public final boolean isIncludeAllowableActions() {
        return this.includeAllowableActions;
    }

    public final void setIncludeAllowableActions(boolean include) {
        this.includeAllowableActions = include;
        this.generateCacheKey();
    }

    public final boolean isIncludePolicies() {
        return this.includePolicies;
    }

    public final void setIncludePolicies(boolean include) {
        this.includePolicies = include;
        this.generateCacheKey();
    }

    public final IncludeRelationships getIncludeRelationships() {
        return this.includeRelationships;
    }

    public final void setIncludeRelationships(IncludeRelationships include) {
        this.includeRelationships = include;
        this.generateCacheKey();
    }

    public final Set<String> getRenditionFilter() {
        if (this.renditionFilter == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.renditionFilter);
    }

    public final void setRenditionFilter(Set<String> renditionFilter) {
        TreeSet<String> tempSet = new TreeSet<String>();
        if (renditionFilter != null) {
            for (String rf : renditionFilter) {
                String trf;
                if (rf == null || (trf = rf.trim()).length() == 0) continue;
                if (trf.indexOf(44) > -1) {
                    throw new IllegalArgumentException("Rendition must not contain a comma!");
                }
                tempSet.add(trf);
            }
            if (tempSet.isEmpty()) {
                tempSet.add(RENDITION_NONE);
            }
        } else {
            tempSet.add(RENDITION_NONE);
        }
        this.renditionFilter = tempSet;
        this.generateCacheKey();
    }

    public final void setRenditionFilterString(String renditionFilter) {
        if (renditionFilter == null || renditionFilter.trim().length() == 0) {
            this.setRenditionFilter(null);
            return;
        }
        String[] renditions = renditionFilter.split(",");
        TreeSet<String> tempSet = new TreeSet<String>();
        for (String rend : renditions) {
            tempSet.add(rend);
        }
        this.setRenditionFilter(tempSet);
    }

    public final String getRenditionFilterString() {
        if (this.renditionFilter == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String rf : this.renditionFilter) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(rf);
        }
        return sb.toString();
    }

    public final boolean isIncludePathSegments() {
        return this.includePathSegments;
    }

    public final void setIncludePathSegments(boolean include) {
        this.includePathSegments = include;
    }

    public final String getOrderBy() {
        return this.orderBy;
    }

    public final void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public final boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public final void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public final String getCacheKey() {
        return this.cacheKey;
    }

    protected final void generateCacheKey() {
        if (!this.cacheEnabled) {
            this.cacheKey = null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.includeAcls ? (char)'1' : '0');
        sb.append(this.includeAllowableActions ? (char)'1' : '0');
        sb.append(this.includePolicies ? (char)'1' : '0');
        sb.append('|');
        sb.append(this.filter == null ? "" : this.getFilterString());
        sb.append('|');
        sb.append(this.includeRelationships == null ? "" : this.includeRelationships.value());
        sb.append('|');
        sb.append(this.renditionFilter == null ? "" : this.getRenditionFilterString());
        this.cacheKey = sb.toString();
    }

    public final int getMaxItemsPerPage() {
        return this.maxItemsPerPage;
    }

    public final void setMaxItemsPerPage(int maxItemsPerPage) {
        if (maxItemsPerPage < 1) {
            throw new IllegalArgumentException("itemsPerPage must be > 0!");
        }
        this.maxItemsPerPage = maxItemsPerPage;
    }
}

