/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.HashSet;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.util.OperationContextUtils;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class PropertyFilterTest
extends AbstractSessionTest {
    private static final String CONTENT = "TCK test content.";
    private static final String INVALID_PROPERTY = "cmis:tck:thisPropertyDoesNotExist";

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Property Filter Test");
        this.setDescription("Tests different property filter combinations for documents and folders.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        OperationContext testContext1 = OperationContextUtils.createMinimumOperationContext();
        HashSet<String> testfilter1 = new HashSet<String>(testContext1.getFilter());
        testfilter1.add("cmis:contentStreamMimeType");
        testContext1.setFilter(testfilter1);
        OperationContext testContext2 = OperationContextUtils.createMinimumOperationContext();
        HashSet<String> testfilter2 = new HashSet<String>(testContext2.getFilter());
        testfilter2.add("cmis:path");
        testContext2.setFilter(testfilter2);
        OperationContext testContext3 = OperationContextUtils.createMinimumOperationContext();
        HashSet<String> testfilter3 = new HashSet<String>(testContext3.getFilter());
        testfilter3.add(INVALID_PROPERTY);
        testContext3.setFilter(testfilter3);
        Folder testFolder = this.createTestFolder(session);
        try {
            Document doc = this.createDocument(session, testFolder, "doc", CONTENT);
            Document doc1 = (Document)session.getObject((ObjectId)doc, testContext1);
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Document should have the property cmis:contentStreamMimeType!");
            this.addResult(this.assertNotNull(doc1.getProperty("cmis:contentStreamMimeType"), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Document should not have the property cmis:path!");
            this.addResult(this.assertNull(doc1.getProperty("cmis:path"), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Document should not have the property cmis:tck:thisPropertyDoesNotExist!");
            this.addResult(this.assertNull(doc1.getProperty(INVALID_PROPERTY), null, f));
            Document doc2 = (Document)session.getObject((ObjectId)doc, testContext2);
            f = this.createResult(CmisTestResultStatus.WARNING, "Document should not have the property cmis:contentStreamMimeType!");
            this.addResult(this.assertNull(doc2.getProperty("cmis:contentStreamMimeType"), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Document should not have the property cmis:path!");
            this.addResult(this.assertNull(doc2.getProperty("cmis:path"), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Document should not have the property cmis:tck:thisPropertyDoesNotExist!");
            this.addResult(this.assertNull(doc2.getProperty(INVALID_PROPERTY), null, f));
            Document doc3 = (Document)session.getObject((ObjectId)doc, testContext3);
            f = this.createResult(CmisTestResultStatus.WARNING, "Document should not have the propertycmis:contentStreamMimeType!");
            this.addResult(this.assertNull(doc3.getProperty("cmis:contentStreamMimeType"), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Document should not have the propertycmis:path!");
            this.addResult(this.assertNull(doc3.getProperty("cmis:path"), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Document should not have the propertycmis:tck:thisPropertyDoesNotExist!");
            this.addResult(this.assertNull(doc3.getProperty(INVALID_PROPERTY), null, f));
            Folder folder1 = (Folder)session.getObject((ObjectId)testFolder, testContext1);
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder should not have the property cmis:contentStreamMimeType!");
            this.addResult(this.assertNull(folder1.getProperty("cmis:contentStreamMimeType"), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Folder should not have the property cmis:path!");
            this.addResult(this.assertNull(folder1.getProperty("cmis:path"), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder should not have the property cmis:tck:thisPropertyDoesNotExist!");
            this.addResult(this.assertNull(folder1.getProperty(INVALID_PROPERTY), null, f));
            Folder folder2 = (Folder)session.getObject((ObjectId)testFolder, testContext2);
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder should not have the property cmis:contentStreamMimeType!");
            this.addResult(this.assertNull(folder2.getProperty("cmis:contentStreamMimeType"), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder should have the property cmis:path!");
            this.addResult(this.assertNotNull(folder2.getProperty("cmis:path"), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder should not have the property cmis:tck:thisPropertyDoesNotExist!");
            this.addResult(this.assertNull(folder2.getProperty(INVALID_PROPERTY), null, f));
            Folder folder3 = (Folder)session.getObject((ObjectId)testFolder, testContext3);
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder should not have the property cmis:contentStreamMimeType!");
            this.addResult(this.assertNull(folder3.getProperty("cmis:contentStreamMimeType"), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Folder should not have the property cmis:path!");
            this.addResult(this.assertNull(folder3.getProperty("cmis:path"), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder should not have the property cmis:tck:thisPropertyDoesNotExist!");
            this.addResult(this.assertNull(folder3.getProperty(INVALID_PROPERTY), null, f));
            CmisObject obj1 = (CmisObject)testFolder.getChildren(testContext1).iterator().next();
            f = this.createResult(CmisTestResultStatus.WARNING, "Child should have the property cmis:contentStreamMimeType!");
            this.addResult(this.assertNotNull(obj1.getProperty("cmis:contentStreamMimeType"), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Child should not have the property cmis:path!");
            this.addResult(this.assertNull(obj1.getProperty("cmis:path"), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Child should not have the property cmis:tck:thisPropertyDoesNotExist!");
            this.addResult(this.assertNull(obj1.getProperty(INVALID_PROPERTY), null, f));
            CmisObject obj2 = (CmisObject)testFolder.getChildren(testContext2).iterator().next();
            f = this.createResult(CmisTestResultStatus.WARNING, "Child should not have the property cmis:contentStreamMimeType!");
            this.addResult(this.assertNull(obj2.getProperty("cmis:contentStreamMimeType"), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Child should not have the property cmis:path!");
            this.addResult(this.assertNull(obj2.getProperty("cmis:path"), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Child should not have the property cmis:tck:thisPropertyDoesNotExist!");
            this.addResult(this.assertNull(obj2.getProperty(INVALID_PROPERTY), null, f));
            CmisObject obj3 = (CmisObject)testFolder.getChildren(testContext3).iterator().next();
            f = this.createResult(CmisTestResultStatus.WARNING, "Child should not have the propertycmis:contentStreamMimeType!");
            this.addResult(this.assertNull(obj3.getProperty("cmis:contentStreamMimeType"), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Child should not have the propertycmis:path!");
            this.addResult(this.assertNull(obj3.getProperty("cmis:path"), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Child should not have the propertycmis:tck:thisPropertyDoesNotExist!");
            this.addResult(this.assertNull(obj3.getProperty(INVALID_PROPERTY), null, f));
        }
        finally {
            this.deleteTestFolder();
        }
    }
}

