/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.jena.facade;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import com.hp.hpl.jena.shared.AlreadyReifiedException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;

public class DirectReifier
implements Reifier {
    private Graph graph;

    public DirectReifier(Graph graph) {
        this.graph = graph;
    }

    public ExtendedIterator find(TripleMatch arg0) {
        return new NullIterator();
    }

    public ExtendedIterator findExposed(TripleMatch arg0) {
        return new NullIterator();
    }

    public ExtendedIterator findEither(TripleMatch arg0, boolean arg1) {
        return new NullIterator();
    }

    public int size() {
        return 0;
    }

    public ReificationStyle getStyle() {
        return ReificationStyle.Standard;
    }

    public Graph getParentGraph() {
        return this.graph;
    }

    public Node reifyAs(Node node, Triple t) {
        if (this.hasTriple(node)) {
            throw new AlreadyReifiedException(node);
        }
        this.graph.add(new Triple(node, RDF.subject.asNode(), t.getSubject()));
        this.graph.add(new Triple(node, RDF.predicate.asNode(), t.getPredicate()));
        this.graph.add(new Triple(node, RDF.object.asNode(), t.getObject()));
        return node;
    }

    public boolean hasTriple(Node node) {
        if (!this.graph.contains(node, RDF.subject.asNode(), null)) {
            return false;
        }
        if (!this.graph.contains(node, RDF.predicate.asNode(), null)) {
            return false;
        }
        if (!this.graph.contains(node, RDF.object.asNode(), null)) {
            return false;
        }
        return false;
    }

    public boolean hasTriple(Triple triple) {
        if (!this.graph.contains(null, RDF.subject.asNode(), triple.getSubject())) {
            return false;
        }
        if (!this.graph.contains(null, RDF.predicate.asNode(), triple.getPredicate())) {
            return false;
        }
        if (!this.graph.contains(null, RDF.object.asNode(), triple.getObject())) {
            return false;
        }
        return false;
    }

    public ExtendedIterator allNodes() {
        ExtendedIterator tripleIter = this.graph.find(null, RDF.subject.asNode(), null);
        final ExtendedIterator filteredTripleIter = tripleIter.filterKeep(new Filter(){

            public boolean accept(Object o) {
                Triple t = (Triple)o;
                return DirectReifier.this.hasTriple(t.getSubject());
            }
        });
        return new NodeIteratorImpl(new Iterator(){

            @Override
            public boolean hasNext() {
                return filteredTripleIter.hasNext();
            }

            public Object next() {
                return ((Triple)filteredTripleIter.next()).getSubject();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }, (Object)this);
    }

    public ExtendedIterator allNodes(final Triple triple) {
        ExtendedIterator tripleIter = this.graph.find(null, RDF.subject.asNode(), triple.getSubject());
        final ExtendedIterator filteredTripleIter = tripleIter.filterKeep(new Filter(){

            public boolean accept(Object o) {
                Triple t = (Triple)o;
                return DirectReifier.this.graph.contains(t.getSubject(), RDF.object.asNode(), triple.getObject()) && DirectReifier.this.graph.contains(t.getSubject(), RDF.predicate.asNode(), triple.getPredicate());
            }
        });
        return new NodeIteratorImpl(new Iterator(){

            @Override
            public boolean hasNext() {
                return filteredTripleIter.hasNext();
            }

            public Object next() {
                return ((Triple)filteredTripleIter.next()).getSubject();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }, (Object)this);
    }

    public void remove(Node arg0, Triple arg1) {
    }

    public void remove(Triple arg0) {
    }

    public boolean handledAdd(Triple arg0) {
        return false;
    }

    public boolean handledRemove(Triple arg0) {
        return false;
    }

    public void close() {
    }

    public Triple getTriple(Node node) {
        ExtendedIterator iter = this.graph.find(node, RDF.subject.asNode(), null);
        if (!iter.hasNext()) {
            return null;
        }
        Node subject = ((Triple)iter.next()).getObject();
        iter = this.graph.find(node, RDF.predicate.asNode(), null);
        if (!iter.hasNext()) {
            return null;
        }
        Node predicate = ((Triple)iter.next()).getObject();
        iter = this.graph.find(node, RDF.object.asNode(), null);
        if (!iter.hasNext()) {
            return null;
        }
        Node object = ((Triple)iter.next()).getObject();
        return new Triple(subject, predicate, object);
    }
}

