/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.xmp;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.JpegConstants;
import org.apache.commons.imaging.formats.jpeg.JpegUtils;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcParser;
import org.apache.commons.imaging.util.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpegRewriter
extends BinaryFileParser {
    private static final ByteOrder JPEG_BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private static final SegmentFilter EXIF_SEGMENT_FILTER = new SegmentFilter(){

        public boolean filter(JFIFPieceSegment segment) {
            return segment.isExifSegment();
        }
    };
    private static final SegmentFilter XMP_SEGMENT_FILTER = new SegmentFilter(){

        public boolean filter(JFIFPieceSegment segment) {
            return segment.isXmpSegment();
        }
    };
    private static final SegmentFilter PHOTOSHOP_APP13_SEGMENT_FILTER = new SegmentFilter(){

        public boolean filter(JFIFPieceSegment segment) {
            return segment.isPhotoshopApp13Segment();
        }
    };

    public JpegRewriter() {
        this.setByteOrder(JPEG_BYTE_ORDER);
    }

    protected JFIFPieces analyzeJFIF(ByteSource byteSource) throws ImageReadException, IOException {
        final ArrayList<JFIFPiece> pieces = new ArrayList<JFIFPiece>();
        final ArrayList<JFIFPiece> segmentPieces = new ArrayList<JFIFPiece>();
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            public boolean beginSOS() {
                return true;
            }

            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
                pieces.add(new JFIFPieceImageData(markerBytes, imageData));
            }

            public boolean visitSegment(int marker, byte[] markerBytes, int segmentLength, byte[] segmentLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                JFIFPieceSegment piece = new JFIFPieceSegment(marker, markerBytes, segmentLengthBytes, segmentData);
                pieces.add(piece);
                segmentPieces.add(piece);
                return true;
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return new JFIFPieces(pieces, segmentPieces);
    }

    protected <T extends JFIFPiece> List<T> removeXmpSegments(List<T> segments) {
        return this.filterSegments(segments, XMP_SEGMENT_FILTER);
    }

    protected <T extends JFIFPiece> List<T> removePhotoshopApp13Segments(List<T> segments) {
        return this.filterSegments(segments, PHOTOSHOP_APP13_SEGMENT_FILTER);
    }

    protected <T extends JFIFPiece> List<T> findPhotoshopApp13Segments(List<T> segments) {
        return this.filterSegments(segments, PHOTOSHOP_APP13_SEGMENT_FILTER, true);
    }

    protected <T extends JFIFPiece> List<T> removeExifSegments(List<T> segments) {
        return this.filterSegments(segments, EXIF_SEGMENT_FILTER);
    }

    protected <T extends JFIFPiece> List<T> filterSegments(List<T> segments, SegmentFilter filter) {
        return this.filterSegments(segments, filter, false);
    }

    protected <T extends JFIFPiece> List<T> filterSegments(List<T> segments, SegmentFilter filter, boolean reverse) {
        ArrayList<JFIFPiece> result = new ArrayList<JFIFPiece>();
        for (JFIFPiece piece : segments) {
            if (piece instanceof JFIFPieceSegment) {
                if (!(filter.filter((JFIFPieceSegment)piece) ^ !reverse)) continue;
                result.add(piece);
                continue;
            }
            if (reverse) continue;
            result.add(piece);
        }
        return result;
    }

    protected <T extends JFIFPiece, U extends JFIFPiece> List<JFIFPiece> insertBeforeFirstAppSegments(List<T> segments, List<U> newSegments) throws ImageWriteException {
        int firstAppIndex = -1;
        for (int i = 0; i < segments.size(); ++i) {
            JFIFPieceSegment segment;
            JFIFPiece piece = (JFIFPiece)segments.get(i);
            if (!(piece instanceof JFIFPieceSegment) || !(segment = (JFIFPieceSegment)piece).isAppSegment() || firstAppIndex != -1) continue;
            firstAppIndex = i;
        }
        ArrayList<JFIFPiece> result = new ArrayList<JFIFPiece>(segments);
        if (firstAppIndex == -1) {
            throw new ImageWriteException("JPEG file has no APP segments.");
        }
        result.addAll(firstAppIndex, newSegments);
        return result;
    }

    protected <T extends JFIFPiece, U extends JFIFPiece> List<JFIFPiece> insertAfterLastAppSegments(List<T> segments, List<U> newSegments) throws ImageWriteException {
        int lastAppIndex = -1;
        for (int i = 0; i < segments.size(); ++i) {
            JFIFPieceSegment segment;
            JFIFPiece piece = (JFIFPiece)segments.get(i);
            if (!(piece instanceof JFIFPieceSegment) || !(segment = (JFIFPieceSegment)piece).isAppSegment()) continue;
            lastAppIndex = i;
        }
        ArrayList<JFIFPiece> result = new ArrayList<JFIFPiece>(segments);
        if (lastAppIndex == -1) {
            if (segments.size() < 1) {
                throw new ImageWriteException("JPEG file has no APP segments.");
            }
            result.addAll(1, newSegments);
        } else {
            result.addAll(lastAppIndex + 1, newSegments);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSegments(OutputStream os, List<? extends JFIFPiece> segments) throws IOException {
        boolean canThrow = false;
        try {
            JpegConstants.SOI.writeTo(os);
            for (JFIFPiece jFIFPiece : segments) {
                jFIFPiece.write(os);
            }
            canThrow = true;
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(canThrow, os);
            throw throwable;
        }
        IoUtils.closeQuietly(canThrow, os);
    }

    public static class JpegSegmentOverflowException
    extends ImageWriteException {
        private static final long serialVersionUID = -1062145751550646846L;

        public JpegSegmentOverflowException(String message) {
            super(message);
        }
    }

    private static interface SegmentFilter {
        public boolean filter(JFIFPieceSegment var1);
    }

    protected static class JFIFPieceImageData
    extends JFIFPiece {
        public final byte[] markerBytes;
        public final byte[] imageData;

        public JFIFPieceImageData(byte[] markerBytes, byte[] imageData) {
            this.markerBytes = markerBytes;
            this.imageData = imageData;
        }

        protected void write(OutputStream os) throws IOException {
            os.write(this.markerBytes);
            os.write(this.imageData);
        }
    }

    protected static class JFIFPieceSegment
    extends JFIFPiece {
        public final int marker;
        public final byte[] markerBytes;
        public final byte[] segmentLengthBytes;
        public final byte[] segmentData;

        public JFIFPieceSegment(int marker, byte[] segmentData) {
            this(marker, ByteConversions.toBytes((short)marker, JPEG_BYTE_ORDER), ByteConversions.toBytes((short)(segmentData.length + 2), JPEG_BYTE_ORDER), segmentData);
        }

        public JFIFPieceSegment(int marker, byte[] markerBytes, byte[] segmentLengthBytes, byte[] segmentData) {
            this.marker = marker;
            this.markerBytes = markerBytes;
            this.segmentLengthBytes = segmentLengthBytes;
            this.segmentData = segmentData;
        }

        public String toString() {
            return "[" + this.getClass().getName() + " (0x" + Integer.toHexString(this.marker) + ")]";
        }

        protected void write(OutputStream os) throws IOException {
            os.write(this.markerBytes);
            os.write(this.segmentLengthBytes);
            os.write(this.segmentData);
        }

        public boolean isApp1Segment() {
            return this.marker == 65505;
        }

        public boolean isAppSegment() {
            return this.marker >= 65504 && this.marker <= 65519;
        }

        public boolean isExifSegment() {
            if (this.marker != 65505) {
                return false;
            }
            return BinaryFunctions.startsWith(this.segmentData, JpegConstants.EXIF_IDENTIFIER_CODE);
        }

        public boolean isPhotoshopApp13Segment() {
            if (this.marker != 65517) {
                return false;
            }
            return new IptcParser().isPhotoshopJpegSegment(this.segmentData);
        }

        public boolean isXmpSegment() {
            if (this.marker != 65505) {
                return false;
            }
            return BinaryFunctions.startsWith(this.segmentData, JpegConstants.XMP_IDENTIFIER);
        }
    }

    protected static abstract class JFIFPiece {
        protected JFIFPiece() {
        }

        protected abstract void write(OutputStream var1) throws IOException;

        public String toString() {
            return "[" + this.getClass().getName() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class JFIFPieces {
        public final List<JFIFPiece> pieces;
        public final List<JFIFPiece> segmentPieces;

        public JFIFPieces(List<JFIFPiece> pieces, List<JFIFPiece> segmentPieces) {
            this.pieces = pieces;
            this.segmentPieces = segmentPieces;
        }
    }
}

