/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccess;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccessManager;
import org.apache.commons.jcs.auxiliary.disk.jdbc.TableState;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.behavior.IStatElement;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCDiskCache<K, V>
extends AbstractDiskCache<K, V> {
    private static final Log log = LogFactory.getLog(JDBCDiskCache.class);
    private IElementSerializer elementSerializer = new StandardSerializer();
    private JDBCDiskCacheAttributes jdbcDiskCacheAttributes;
    private int updateCount = 0;
    private int getCount = 0;
    private int getMatchingCount = 0;
    private static final int LOG_INTERVAL = 100;
    private JDBCDiskCachePoolAccess poolAccess = null;
    private TableState tableState;

    public JDBCDiskCache(JDBCDiskCacheAttributes cattr, TableState tableState, ICompositeCacheManager compositeCacheManager) throws SQLException {
        super(cattr);
        this.setTableState(tableState);
        this.setJdbcDiskCacheAttributes(cattr);
        if (log.isInfoEnabled()) {
            log.info((Object)("jdbcDiskCacheAttributes = " + this.getJdbcDiskCacheAttributes()));
        }
        this.poolAccess = this.initializePoolAccess(cattr, compositeCacheManager);
        this.alive = true;
    }

    protected JDBCDiskCachePoolAccess initializePoolAccess(JDBCDiskCacheAttributes cattr, ICompositeCacheManager compositeCacheManager) throws SQLException {
        JDBCDiskCachePoolAccess poolAccess1 = null;
        if (cattr.getConnectionPoolName() != null) {
            JDBCDiskCachePoolAccessManager manager = JDBCDiskCachePoolAccessManager.getInstance();
            poolAccess1 = manager.getJDBCDiskCachePoolAccess(cattr.getConnectionPoolName(), compositeCacheManager.getConfigurationProperties());
        } else {
            poolAccess1 = JDBCDiskCachePoolAccessManager.createPoolAccess(cattr);
        }
        return poolAccess1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processUpdate(ICacheElement<K, V> ce) {
        Connection con;
        this.incrementUpdateCount();
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating, ce = " + ce));
        }
        try {
            con = this.getPoolAccess().getConnection();
        }
        catch (SQLException e) {
            log.error((Object)"Problem getting connection.", (Throwable)e);
            return;
        }
        try {
            byte[] element;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Putting [" + ce.getKey() + "] on disk."));
            }
            try {
                element = this.getElementSerializer().serialize(ce);
            }
            catch (IOException e) {
                log.error((Object)"Could not serialize element", (Throwable)e);
                try {
                    con.close();
                }
                catch (SQLException e2) {
                    log.error((Object)"Problem closing connection.", (Throwable)e2);
                }
                return;
            }
            this.insertOrUpdate(ce, con, element);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)"Problem closing connection.", (Throwable)e);
            }
        }
        if (log.isInfoEnabled() && this.updateCount % 100 == 0) {
            log.info((Object)("Update Count [" + this.updateCount + "]"));
        }
    }

    private void insertOrUpdate(ICacheElement<K, V> ce, Connection con, byte[] element) {
        boolean exists = false;
        if (this.getJdbcDiskCacheAttributes().isTestBeforeInsert()) {
            exists = this.doesElementExist(ce);
        }
        if (!exists) {
            exists = this.insertRow(ce, con, element);
        }
        if (exists) {
            this.updateRow(ce, con, element);
        }
    }

    private boolean insertRow(ICacheElement<K, V> ce, Connection con, byte[] element) {
        boolean exists;
        block6: {
            exists = false;
            try {
                String sqlI = "insert into " + this.getJdbcDiskCacheAttributes().getTableName() + " (CACHE_KEY, REGION, ELEMENT, MAX_LIFE_SECONDS, IS_ETERNAL, CREATE_TIME, UPDATE_TIME_SECONDS, SYSTEM_EXPIRE_TIME_SECONDS) " + " values (?, ?, ?, ?, ?, ?, ?, ?)";
                PreparedStatement psInsert = con.prepareStatement(sqlI);
                psInsert.setString(1, (String)ce.getKey());
                psInsert.setString(2, this.getCacheName());
                psInsert.setBytes(3, element);
                psInsert.setLong(4, ce.getElementAttributes().getMaxLife());
                if (ce.getElementAttributes().getIsEternal()) {
                    psInsert.setString(5, "T");
                } else {
                    psInsert.setString(5, "F");
                }
                Timestamp createTime = new Timestamp(ce.getElementAttributes().getCreateTime());
                psInsert.setTimestamp(6, createTime);
                long now = System.currentTimeMillis() / 1000L;
                psInsert.setLong(7, now);
                long expireTime = now + ce.getElementAttributes().getMaxLife();
                psInsert.setLong(8, expireTime);
                psInsert.execute();
                psInsert.close();
            }
            catch (SQLException e) {
                if ("23000".equals(e.getSQLState())) {
                    exists = true;
                } else {
                    log.error((Object)"Could not insert element", (Throwable)e);
                }
                if (exists || this.getJdbcDiskCacheAttributes().isTestBeforeInsert()) break block6;
                exists = this.doesElementExist(ce);
            }
        }
        return exists;
    }

    private void updateRow(ICacheElement<K, V> ce, Connection con, byte[] element) {
        String sqlU = null;
        try {
            sqlU = "update " + this.getJdbcDiskCacheAttributes().getTableName() + " set ELEMENT  = ?, CREATE_TIME = ?, UPDATE_TIME_SECONDS = ?, " + " SYSTEM_EXPIRE_TIME_SECONDS = ? " + " where CACHE_KEY = ? and REGION = ?";
            PreparedStatement psUpdate = con.prepareStatement(sqlU);
            psUpdate.setBytes(1, element);
            Timestamp createTime = new Timestamp(ce.getElementAttributes().getCreateTime());
            psUpdate.setTimestamp(2, createTime);
            long now = System.currentTimeMillis() / 1000L;
            psUpdate.setLong(3, now);
            long expireTime = now + ce.getElementAttributes().getMaxLife();
            psUpdate.setLong(4, expireTime);
            psUpdate.setString(5, (String)ce.getKey());
            psUpdate.setString(6, this.getCacheName());
            psUpdate.execute();
            psUpdate.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("ran update " + sqlU));
            }
        }
        catch (SQLException e2) {
            log.error((Object)("e2 sql [" + sqlU + "] Exception: "), (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doesElementExist(ICacheElement<K, V> ce) {
        Connection con;
        boolean exists = false;
        try {
            con = this.getPoolAccess().getConnection();
        }
        catch (SQLException e) {
            log.error((Object)"Problem getting connection.", (Throwable)e);
            return exists;
        }
        Statement psSelect = null;
        try {
            String sqlS = "select CACHE_KEY from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY = ?";
            psSelect = con.prepareStatement(sqlS);
            psSelect.setString(1, this.getCacheName());
            psSelect.setString(2, (String)ce.getKey());
            ResultSet rs = psSelect.executeQuery();
            if (rs.next()) {
                exists = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + ce.getKey() + "] existing status is " + exists));
            }
            rs.close();
        }
        catch (SQLException e) {
            log.error((Object)"Problem looking for item before insert.", (Throwable)e);
        }
        finally {
            try {
                if (psSelect != null) {
                    psSelect.close();
                }
            }
            catch (SQLException e1) {
                log.error((Object)"Problem closing statement.", (Throwable)e1);
            }
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)"Problem closing connection.", (Throwable)e);
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ICacheElement<K, V> processGet(K key) {
        this.incrementGetCount();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting [" + key + "] from disk"));
        }
        if (!this.alive) {
            return null;
        }
        ICacheElement obj = null;
        byte[] data = null;
        try {
            String selectString = "select ELEMENT from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY = ?";
            Connection con = this.getPoolAccess().getConnection();
            try {
                PreparedStatement psSelect = null;
                try {
                    psSelect = con.prepareStatement(selectString);
                    psSelect.setString(1, this.getCacheName());
                    psSelect.setString(2, key.toString());
                    ResultSet rs = psSelect.executeQuery();
                    try {
                        if (rs.next()) {
                            data = rs.getBytes(1);
                        }
                        if (data != null) {
                            try {
                                obj = (ICacheElement)this.getElementSerializer().deSerialize(data, null);
                            }
                            catch (IOException ioe) {
                                log.error((Object)("Problem getting item for key [" + key + "]"), (Throwable)ioe);
                            }
                            catch (Exception e) {
                                log.error((Object)("Problem getting item for key [" + key + "]"), (Throwable)e);
                            }
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (psSelect != null) {
                        psSelect.close();
                    }
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (SQLException sqle) {
            log.error((Object)("Caught a SQL exception trying to get the item for key [" + key + "]"), (Throwable)sqle);
        }
        if (log.isInfoEnabled() && this.getCount % 100 == 0) {
            log.info((Object)("Get Count [" + this.getCount + "]"));
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<K, ICacheElement<K, V>> processGetMatching(String pattern) {
        HashMap<String, ICacheElement> results;
        block22: {
            this.incrementGetMatchingCount();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting [" + pattern + "] from disk"));
            }
            if (!this.alive) {
                return null;
            }
            results = new HashMap<String, ICacheElement>();
            try {
                String selectString = "select CACHE_KEY, ELEMENT from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY like ?";
                Connection con = this.getPoolAccess().getConnection();
                try {
                    PreparedStatement psSelect = null;
                    try {
                        psSelect = con.prepareStatement(selectString);
                        psSelect.setString(1, this.getCacheName());
                        psSelect.setString(2, this.constructLikeParameterFromPattern(pattern));
                        ResultSet rs = psSelect.executeQuery();
                        block14: while (true) {
                            while (rs.next()) {
                                String key = rs.getString(1);
                                byte[] data = rs.getBytes(2);
                                if (data == null) continue;
                                try {
                                    ICacheElement value = (ICacheElement)this.getElementSerializer().deSerialize(data, null);
                                    results.put(key, value);
                                    continue block14;
                                }
                                catch (IOException ioe) {
                                    log.error((Object)("Problem getting items for pattern [" + pattern + "]"), (Throwable)ioe);
                                }
                                catch (Exception e) {
                                    log.error((Object)("Problem getting items for pattern [" + pattern + "]"), (Throwable)e);
                                }
                            }
                            break block22;
                            {
                                continue block14;
                                break;
                            }
                            break;
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (psSelect != null) {
                            psSelect.close();
                        }
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (SQLException sqle) {
                log.error((Object)("Caught a SQL exception trying to get items for pattern [" + pattern + "]"), (Throwable)sqle);
            }
        }
        if (log.isInfoEnabled() && this.getMatchingCount % 100 == 0) {
            log.info((Object)("Get Matching Count [" + this.getMatchingCount + "]"));
        }
        return results;
    }

    public String constructLikeParameterFromPattern(String pattern) {
        String likePattern = pattern.replaceAll("\\.\\+", "%");
        likePattern = likePattern.replaceAll("\\.", "_");
        if (log.isDebugEnabled()) {
            log.debug((Object)("pattern = [" + likePattern + "]"));
        }
        return likePattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processRemove(K key) {
        String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY = ?";
        try {
            boolean partial = false;
            if (key instanceof String && key.toString().endsWith(":")) {
                sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY like ?";
                partial = true;
            }
            Connection con = this.getPoolAccess().getConnection();
            PreparedStatement psSelect = null;
            try {
                psSelect = con.prepareStatement(sql);
                psSelect.setString(1, this.getCacheName());
                if (partial) {
                    psSelect.setString(2, key.toString() + "%");
                } else {
                    psSelect.setString(2, key.toString());
                }
                psSelect.executeUpdate();
                this.alive = true;
            }
            catch (SQLException e) {
                log.error((Object)("Problem creating statement. sql [" + sql + "]"), (Throwable)e);
                this.alive = false;
            }
            finally {
                try {
                    if (psSelect != null) {
                        psSelect.close();
                    }
                    con.close();
                }
                catch (SQLException e1) {
                    log.error((Object)"Problem closing statement.", (Throwable)e1);
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"Problem updating cache.", (Throwable)e);
            this.reset();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRemoveAll() {
        if (this.jdbcDiskCacheAttributes.isAllowRemoveAll()) {
            try {
                String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ?";
                Connection con = this.getPoolAccess().getConnection();
                PreparedStatement psDelete = null;
                try {
                    psDelete = con.prepareStatement(sql);
                    psDelete.setString(1, this.getCacheName());
                    this.alive = true;
                    psDelete.executeUpdate();
                }
                catch (SQLException e) {
                    log.error((Object)"Problem creating statement.", (Throwable)e);
                    this.alive = false;
                }
                finally {
                    try {
                        if (psDelete != null) {
                            psDelete.close();
                        }
                        con.close();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Problem closing statement.", (Throwable)e1);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Problem removing all.", (Throwable)e);
                this.reset();
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"RemoveAll was requested but the request was not fulfilled: allowRemoveAll is set to false.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deleteExpired() {
        int deleted = 0;
        try {
            this.getTableState().setState(1);
            long now = System.currentTimeMillis() / 1000L;
            String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where IS_ETERNAL = ? and REGION = ? and ? > SYSTEM_EXPIRE_TIME_SECONDS";
            Connection con = this.getPoolAccess().getConnection();
            PreparedStatement psDelete = null;
            try {
                psDelete = con.prepareStatement(sql);
                psDelete.setString(1, "F");
                psDelete.setString(2, this.getCacheName());
                psDelete.setLong(3, now);
                this.alive = true;
                deleted = psDelete.executeUpdate();
            }
            catch (SQLException e) {
                log.error((Object)"Problem creating statement.", (Throwable)e);
                this.alive = false;
            }
            finally {
                try {
                    if (psDelete != null) {
                        psDelete.close();
                    }
                    con.close();
                }
                catch (SQLException e1) {
                    log.error((Object)"Problem closing statement.", (Throwable)e1);
                }
            }
            this.logApplicationEvent(this.getAuxiliaryCacheAttributes().getName(), "deleteExpired", "Deleted expired elements.  URL: " + this.getDiskLocation());
        }
        catch (Exception e) {
            this.logError(this.getAuxiliaryCacheAttributes().getName(), "deleteExpired", e.getMessage() + " URL: " + this.getDiskLocation());
            log.error((Object)"Problem removing expired elements from the table.", (Throwable)e);
            this.reset();
        }
        finally {
            this.getTableState().setState(0);
        }
        return deleted;
    }

    public void reset() {
    }

    @Override
    public void processDispose() {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(this.cacheName, "none", "dispose");
        try {
            try {
                this.getPoolAccess().shutdownDriver();
            }
            catch (Exception e) {
                log.error((Object)"Problem shutting down.", (Throwable)e);
            }
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        Connection con;
        int size = 0;
        String selectString = "select count(*) from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ?";
        JDBCDiskCachePoolAccess pool = this.getPoolAccess();
        if (pool == null) {
            return size;
        }
        try {
            con = pool.getConnection();
        }
        catch (SQLException e1) {
            log.error((Object)"Problem getting connection.", (Throwable)e1);
            return size;
        }
        try {
            PreparedStatement psSelect = null;
            try {
                psSelect = con.prepareStatement(selectString);
                psSelect.setString(1, this.getCacheName());
                ResultSet rs = null;
                rs = psSelect.executeQuery();
                try {
                    if (rs.next()) {
                        size = rs.getInt(1);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (psSelect != null) {
                    psSelect.close();
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"Problem getting size.", (Throwable)e);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)"Problem closing connection.", (Throwable)e);
            }
        }
        return size;
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        throw new UnsupportedOperationException("Groups not implemented.");
    }

    @Override
    public void setElementSerializer(IElementSerializer elementSerializer) {
        this.elementSerializer = elementSerializer;
    }

    @Override
    public IElementSerializer getElementSerializer() {
        return this.elementSerializer;
    }

    private synchronized void incrementUpdateCount() {
        ++this.updateCount;
    }

    private synchronized void incrementGetCount() {
        ++this.getCount;
    }

    private synchronized void incrementGetMatchingCount() {
        ++this.getMatchingCount;
    }

    protected void setJdbcDiskCacheAttributes(JDBCDiskCacheAttributes jdbcDiskCacheAttributes) {
        this.jdbcDiskCacheAttributes = jdbcDiskCacheAttributes;
    }

    protected JDBCDiskCacheAttributes getJdbcDiskCacheAttributes() {
        return this.jdbcDiskCacheAttributes;
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.getJdbcDiskCacheAttributes();
    }

    @Override
    public IStats getStatistics() {
        IStats stats = super.getStatistics();
        stats.setTypeName("JDBC/Abstract Disk Cache");
        List<IStatElement<?>> elems = stats.getStatElements();
        elems.add(new StatElement<Integer>("Update Count", this.updateCount));
        elems.add(new StatElement<Integer>("Get Count", this.getCount));
        elems.add(new StatElement<Integer>("Get Matching Count", this.getMatchingCount));
        JDBCDiskCachePoolAccess pool = this.getPoolAccess();
        elems.add(new StatElement<Integer>("Size", pool != null ? this.getSize() : -1));
        elems.add(new StatElement<Integer>("Active DB Connections", pool != null ? pool.getNumActiveInPool() : -1));
        elems.add(new StatElement<Integer>("Idle DB Connections", pool != null ? pool.getNumIdleInPool() : -1));
        elems.add(new StatElement<String>("DB URL", pool != null ? pool.getPoolUrl() : this.getJdbcDiskCacheAttributes().getUrl()));
        stats.setStatElements(elems);
        return stats;
    }

    protected String getTableName() {
        String name = "UNDEFINED";
        if (this.getJdbcDiskCacheAttributes() != null) {
            name = this.getJdbcDiskCacheAttributes().getTableName();
        }
        return name;
    }

    public void setTableState(TableState tableState) {
        this.tableState = tableState;
    }

    public TableState getTableState() {
        return this.tableState;
    }

    @Override
    protected String getDiskLocation() {
        return this.jdbcDiskCacheAttributes.getUrl();
    }

    public JDBCDiskCachePoolAccess getPoolAccess() {
        return this.poolAccess;
    }

    public String toString() {
        return this.getStats();
    }
}

