/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCacheFactory;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.jdbc.ShrinkerThread;
import org.apache.commons.jcs.auxiliary.disk.jdbc.TableState;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCDiskCacheFactory
extends AbstractAuxiliaryCacheFactory {
    private static final Log log = LogFactory.getLog(JDBCDiskCacheFactory.class);
    private Map<String, TableState> tableStates;
    protected ScheduledExecutorService scheduler;
    private Map<String, ShrinkerThread> shrinkerThreadMap;

    public <K, V> JDBCDiskCache<K, V> createCache(AuxiliaryCacheAttributes rawAttr, ICompositeCacheManager compositeCacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) throws SQLException {
        JDBCDiskCacheAttributes cattr = (JDBCDiskCacheAttributes)rawAttr;
        TableState tableState = this.getTableState(cattr.getTableName());
        JDBCDiskCache cache = new JDBCDiskCache(cattr, tableState, compositeCacheManager);
        cache.setCacheEventLogger(cacheEventLogger);
        cache.setElementSerializer(elementSerializer);
        this.createShrinkerWhenNeeded(cattr, cache);
        return cache;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.tableStates = new HashMap<String, TableState>();
        this.shrinkerThreadMap = new HashMap<String, ShrinkerThread>();
    }

    @Override
    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
        super.dispose();
    }

    protected TableState getTableState(String tableName) {
        TableState tableState = this.tableStates.get(tableName);
        if (tableState == null) {
            tableState = new TableState(tableName);
            this.tableStates.put(tableName, tableState);
        }
        return tableState;
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        if (this.scheduler == null) {
            this.scheduler = Executors.newScheduledThreadPool(2, new DaemonThreadFactory("JCS-JDBCDiskCacheManager-", 1));
        }
        return this.scheduler;
    }

    protected void createShrinkerWhenNeeded(JDBCDiskCacheAttributes cattr, JDBCDiskCache<?, ?> raf) {
        if (cattr.isUseDiskShrinker()) {
            ScheduledExecutorService shrinkerService = this.getScheduledExecutorService();
            ShrinkerThread shrinkerThread = this.shrinkerThreadMap.get(cattr.getTableName());
            if (shrinkerThread == null) {
                shrinkerThread = new ShrinkerThread();
                this.shrinkerThreadMap.put(cattr.getTableName(), shrinkerThread);
                long intervalMillis = Math.max(999, cattr.getShrinkerIntervalSeconds() * 1000);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Setting the shrinker to run every [" + intervalMillis + "] ms. for table [" + cattr.getTableName() + "]"));
                }
                shrinkerService.scheduleAtFixedRate(shrinkerThread, 0L, intervalMillis, TimeUnit.MILLISECONDS);
            }
            shrinkerThread.addDiskCacheToShrinkList(raf);
        }
    }
}

