/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

public class JDBCDiskCachePoolAccess {
    private static final Log log = LogFactory.getLog(JDBCDiskCachePoolAccess.class);
    public static final String DEFAULT_POOL_NAME = "jcs";
    private String poolName = "jcs";
    private static final String DRIVER_NAME = "jdbc:apache:commons:dbcp:";

    public JDBCDiskCachePoolAccess(String poolName) {
        if (poolName != null) {
            this.setPoolName(poolName);
        } else if (log.isInfoEnabled()) {
            log.info((Object)"The pool name supplied was null. Using default instead.");
        }
    }

    public Connection getConnection() throws SQLException {
        Connection con;
        try {
            con = DriverManager.getConnection(this.getPoolUrl());
        }
        catch (SQLException e) {
            log.error((Object)"Problem getting connection.", (Throwable)e);
            throw e;
        }
        return con;
    }

    public int getNumIdleInPool() {
        int numIdle = 0;
        try {
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(DRIVER_NAME);
            ObjectPool connectionPool = driver.getConnectionPool(this.getPoolName());
            if (log.isDebugEnabled()) {
                log.debug((Object)connectionPool);
            }
            numIdle = connectionPool.getNumIdle();
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        return numIdle;
    }

    public int getNumActiveInPool() {
        int numActive = 0;
        try {
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(DRIVER_NAME);
            ObjectPool connectionPool = driver.getConnectionPool(this.getPoolName());
            if (log.isDebugEnabled()) {
                log.debug((Object)connectionPool);
            }
            numActive = connectionPool.getNumActive();
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        return numActive;
    }

    public void shutdownDriver() throws SQLException {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(DRIVER_NAME);
        driver.closePool(this.getPoolName());
    }

    public String getPoolUrl() {
        return DRIVER_NAME + this.getPoolName();
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setupDriver(String connectURI, String userName, String password, int maxActive) throws SQLException {
        GenericObjectPool connectionPool = new GenericObjectPool(null, maxActive);
        connectionPool.setMaxIdle(-1);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectURI, userName, password);
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
        try {
            Class.forName("org.apache.commons.dbcp.PoolingDriver");
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Couldn't find class for driver [org.apache.commons.dbcp.PoolingDriver]", e);
        }
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(DRIVER_NAME);
        driver.registerPool(this.getPoolName(), (ObjectPool)connectionPool);
    }

    public void logDriverStats() throws SQLException {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(DRIVER_NAME);
        ObjectPool connectionPool = driver.getConnectionPool(this.getPoolName());
        if (connectionPool != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)connectionPool);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("NumActive: " + this.getNumActiveInPool()));
                log.info((Object)("NumIdle: " + this.getNumIdleInPool()));
            }
        } else {
            log.warn((Object)"Could not find pool.");
        }
    }
}

