/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.LateralTCPCacheFactory;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralCacheMonitor
extends Thread {
    private static final Log log = LogFactory.getLog(LateralCacheMonitor.class);
    private static long idlePeriod = 20000L;
    private boolean allright = true;
    private ConcurrentHashMap<String, LateralCacheNoWait<?, ?>> caches;
    private LateralTCPCacheFactory factory;
    private boolean shutdown = false;
    private static final int ERROR = 1;
    private static int mode = 1;

    public static void setIdlePeriod(long idlePeriod) {
        if (idlePeriod > LateralCacheMonitor.idlePeriod) {
            LateralCacheMonitor.idlePeriod = idlePeriod;
        }
    }

    protected static void forceShortIdlePeriod(long idlePeriod) {
        LateralCacheMonitor.idlePeriod = idlePeriod;
    }

    public LateralCacheMonitor(LateralTCPCacheFactory factory) {
        super("JCS-LateralCacheMonitor");
        this.factory = factory;
        this.caches = new ConcurrentHashMap();
    }

    public void addCache(LateralCacheNoWait<?, ?> cache) {
        this.caches.put(cache.getCacheName(), cache);
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyError() {
        this.bad();
        LateralCacheMonitor lateralCacheMonitor = this;
        synchronized (lateralCacheMonitor) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyShutdown() {
        LateralCacheMonitor lateralCacheMonitor = this;
        synchronized (lateralCacheMonitor) {
            this.shutdown = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object;
            if (mode == 1) {
                if (log.isDebugEnabled()) {
                    if (this.allright) {
                        log.debug((Object)("ERROR DRIVEN MODE: allright = " + this.allright + ", connection monitor will wait for an error."));
                    } else {
                        log.debug((Object)("ERROR DRIVEN MODE: allright = " + this.allright + " connection monitor running."));
                    }
                }
                object = this;
                synchronized (object) {
                    if (this.allright) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            log.debug((Object)("TIME DRIVEN MODE: connection monitor will sleep for " + idlePeriod + " after this run."));
            object = this;
            synchronized (object) {
                if (this.shutdown) {
                    log.info((Object)"Shutting down cache monitor");
                    this.caches.clear();
                    return;
                }
            }
            object = this;
            synchronized (object) {
                this.allright = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cache monitor running.");
            }
            log.info((Object)("Number of caches to monitor = " + this.caches.size()));
            for (Map.Entry entry : this.caches.entrySet()) {
                String cacheName = (String)entry.getKey();
                LateralCacheNoWait c = (LateralCacheNoWait)entry.getValue();
                if (c.getStatus() != CacheStatus.ERROR) continue;
                log.info((Object)("Found LateralCacheNoWait in error, " + cacheName));
                ITCPLateralCacheAttributes lca = (ITCPLateralCacheAttributes)c.getAuxiliaryCacheAttributes();
                ICacheServiceNonLocal cacheService = this.factory.getCSNLInstance(lca);
                if (cacheService instanceof ZombieCacheServiceNonLocal) continue;
                c.fixCache(cacheService);
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Lateral cache monitor sleeping for " + idlePeriod + " between runs."));
                }
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bad() {
        if (this.allright) {
            LateralCacheMonitor lateralCacheMonitor = this;
            synchronized (lateralCacheMonitor) {
                this.allright = false;
            }
        }
    }
}

