/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral.socket.tcp;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.jcs.auxiliary.lateral.LateralElementDescriptor;
import org.apache.commons.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralTCPSender {
    private static final Log log = LogFactory.getLog(LateralTCPSender.class);
    private int socketOpenTimeOut;
    private int socketSoTimeOut;
    private ObjectOutputStream oos;
    private Socket socket;
    private int sendCnt = 0;
    private final Object getLock = new int[0];

    public LateralTCPSender(ITCPLateralCacheAttributes lca) throws IOException {
        this.socketOpenTimeOut = lca.getOpenTimeOut();
        this.socketSoTimeOut = lca.getSocketTimeOut();
        String p1 = lca.getTcpServer();
        if (p1 == null) {
            throw new IOException("Invalid server (null)");
        }
        String h2 = p1.substring(0, p1.indexOf(":"));
        int po = Integer.parseInt(p1.substring(p1.indexOf(":") + 1));
        if (log.isDebugEnabled()) {
            log.debug((Object)("h2 = " + h2));
            log.debug((Object)("po = " + po));
        }
        if (h2.length() == 0) {
            throw new IOException("Cannot connect to invalid address [" + h2 + ":" + po + "]");
        }
        this.init(h2, po);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(String host, int port) throws IOException {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Attempting connection to [" + host + "]"));
            }
            try {
                this.socket = new Socket();
                this.socket.connect(new InetSocketAddress(host, port), this.socketOpenTimeOut);
            }
            catch (IOException ioe) {
                if (this.socket != null) {
                    this.socket.close();
                }
                throw new IOException("Cannot connect to " + host + ":" + port, ioe);
            }
            this.socket.setSoTimeout(this.socketSoTimeOut);
            LateralTCPSender ioe = this;
            synchronized (ioe) {
                this.oos = new ObjectOutputStream(this.socket.getOutputStream());
            }
        }
        catch (ConnectException e) {
            log.debug((Object)("Remote host [" + host + "] refused connection."));
            throw e;
        }
        catch (IOException e) {
            log.debug((Object)("Could not connect to [" + host + "]. Exception is " + e));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void send(LateralElementDescriptor<K, V> led) throws IOException {
        ++this.sendCnt;
        if (log.isInfoEnabled() && this.sendCnt % 100 == 0) {
            log.info((Object)("Send Count (port " + this.socket.getPort() + ") = " + this.sendCnt));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"sending LateralElementDescriptor");
        }
        if (led == null) {
            return;
        }
        if (this.oos == null) {
            throw new IOException("No remote connection is available for LateralTCPSender.");
        }
        Object object = this.getLock;
        synchronized (object) {
            this.oos.writeUnshared(led);
            this.oos.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Object sendAndReceive(LateralElementDescriptor<K, V> led) throws IOException {
        if (led == null) {
            return null;
        }
        if (this.oos == null) {
            throw new IOException("No remote connection is available for LateralTCPSender.");
        }
        Object response = null;
        Object object = this.getLock;
        synchronized (object) {
            try {
                if (this.socket.getInputStream().available() > 0) {
                    this.socket.getInputStream().read(new byte[this.socket.getInputStream().available()]);
                }
            }
            catch (IOException ioe) {
                log.error((Object)("Problem cleaning socket before send " + this.socket), (Throwable)ioe);
                throw ioe;
            }
            this.oos.writeUnshared(led);
            this.oos.flush();
            try {
                this.socket.setSoTimeout(this.socketSoTimeOut);
                ObjectInputStreamClassLoaderAware ois = new ObjectInputStreamClassLoaderAware(this.socket.getInputStream(), null);
                response = ois.readObject();
            }
            catch (IOException ioe) {
                String message = "Could not open ObjectInputStream to " + this.socket;
                message = message + " SoTimeout [" + this.socket.getSoTimeout() + "] Connected [" + this.socket.isConnected() + "]";
                log.error((Object)message, (Throwable)ioe);
                throw ioe;
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return response;
    }

    public void dispose() throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Dispose called");
        }
        this.oos.close();
        this.socket.close();
    }
}

