/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheElementSerialized;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.utils.net.HostNameUtil;
import org.apache.commons.jcs.utils.serialization.SerializationConversionUtil;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRemoteCacheListener<K, V>
implements IRemoteCacheListener<K, V>,
Serializable {
    private static final long serialVersionUID = 32442324243243L;
    private static final Log log = LogFactory.getLog(AbstractRemoteCacheListener.class);
    private static String localHostName = null;
    private transient ICompositeCacheManager cacheMgr;
    private final IRemoteCacheAttributes irca;
    protected int puts = 0;
    protected int removes = 0;
    private long listenerId = 0L;
    private transient IElementSerializer elementSerializer = new StandardSerializer();

    public AbstractRemoteCacheListener(IRemoteCacheAttributes irca, ICompositeCacheManager cacheMgr) {
        this.irca = irca;
        this.cacheMgr = cacheMgr;
    }

    @Override
    public void setListenerId(long id) throws IOException {
        this.listenerId = id;
        if (log.isInfoEnabled()) {
            log.info((Object)("set listenerId = [" + id + "]"));
        }
    }

    @Override
    public long getListenerId() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("get listenerId = [" + this.listenerId + "]"));
        }
        return this.listenerId;
    }

    @Override
    public RemoteType getRemoteType() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getRemoteType = [" + (Object)((Object)this.irca.getRemoteType()) + "]"));
        }
        return this.irca.getRemoteType();
    }

    @Override
    public void handlePut(ICacheElement<K, V> cb) throws IOException {
        if (this.irca.getRemoveUponRemotePut()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"PUTTING ELEMENT FROM REMOTE, (  invalidating ) ");
            }
            this.handleRemove(cb.getCacheName(), cb.getKey());
        } else {
            ++this.puts;
            if (log.isDebugEnabled()) {
                log.debug((Object)"PUTTING ELEMENT FROM REMOTE, ( updating ) ");
                log.debug((Object)("cb = " + cb));
                if (this.puts % 100 == 0) {
                    log.debug((Object)("puts = " + this.puts));
                }
            }
            CompositeCache<K, V> cache = this.getCacheManager().getCache(cb.getCacheName());
            if (cb instanceof ICacheElementSerialized) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Object needs to be deserialized.");
                }
                try {
                    cb = SerializationConversionUtil.getDeSerializedCacheElement((ICacheElementSerialized)cb, this.elementSerializer);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Deserialized result = " + cb));
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)"Received a serialized version of a class that we don't know about.", (Throwable)e);
                }
            }
            cache.localUpdate(cb);
        }
    }

    @Override
    public void handleRemove(String cacheName, K key) throws IOException {
        ++this.removes;
        if (log.isDebugEnabled()) {
            if (this.removes % 100 == 0) {
                log.debug((Object)("removes = " + this.removes));
            }
            log.debug((Object)("handleRemove> cacheName=" + cacheName + ", key=" + key));
        }
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        cache.localRemove(key);
    }

    @Override
    public void handleRemoveAll(String cacheName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleRemoveAll> cacheName=" + cacheName));
        }
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        cache.localRemoveAll();
    }

    @Override
    public void handleDispose(String cacheName) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleDispose> cacheName=" + cacheName));
        }
    }

    protected ICompositeCacheManager getCacheManager() {
        if (this.cacheMgr == null) {
            try {
                this.cacheMgr = CompositeCacheManager.getInstance();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"had to get cacheMgr");
                    log.debug((Object)("cacheMgr = " + this.cacheMgr));
                }
            }
            catch (CacheException e) {
                log.error((Object)"Could not get cacheMgr", (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("already got cacheMgr = " + this.cacheMgr));
        }
        return this.cacheMgr;
    }

    @Override
    public synchronized String getLocalHostAddress() throws IOException {
        if (localHostName == null) {
            try {
                localHostName = HostNameUtil.getLocalHostAddress();
            }
            catch (UnknownHostException uhe) {
                localHostName = "unknown";
            }
        }
        return localHostName;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n AbstractRemoteCacheListener: ");
        buf.append("\n RemoteHost = " + this.irca.getRemoteHost());
        buf.append("\n RemotePort = " + this.irca.getRemotePort());
        buf.append("\n ListenerId = " + this.listenerId);
        return buf.toString();
    }
}

