/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.IOException;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheManager;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheFailoverRunner<K, V>
implements Runnable {
    private static final Log log = LogFactory.getLog(RemoteCacheFailoverRunner.class);
    private final RemoteCacheNoWaitFacade<K, V> facade;
    private static long idlePeriod = 20000L;
    private boolean alright = true;
    private final ICompositeCacheManager cacheMgr;
    private final ICacheEventLogger cacheEventLogger;
    private final IElementSerializer elementSerializer;

    public RemoteCacheFailoverRunner(RemoteCacheNoWaitFacade<K, V> facade, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        this.facade = facade;
        this.cacheMgr = cacheMgr;
        this.cacheEventLogger = cacheEventLogger;
        this.elementSerializer = elementSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyError() {
        this.bad();
        RemoteCacheFailoverRunner remoteCacheFailoverRunner = this;
        synchronized (remoteCacheFailoverRunner) {
            this.notify();
        }
    }

    @Override
    public void run() {
        this.connectAndRestore();
        if (log.isInfoEnabled()) {
            log.info((Object)("Exiting failover runner. Failover index = " + this.facade.getRemoteCacheAttributes().getFailoverIndex()));
            if (this.facade.getRemoteCacheAttributes().getFailoverIndex() <= 0) {
                log.info((Object)"Failover index is <= 0, meaning we are not connected to a failover server.");
            } else if (this.facade.getRemoteCacheAttributes().getFailoverIndex() > 0) {
                log.info((Object)"Failover index is > 0, meaning we are connected to a failover server.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAndRestore() {
        do {
            log.info((Object)"Remote cache FAILOVER RUNNING.");
            if (!this.alright) {
                String[] failovers = this.facade.getRemoteCacheAttributes().getFailovers();
                if (failovers == null) {
                    log.warn((Object)"Remote is misconfigured, failovers was null.");
                    return;
                }
                if (failovers.length == 1 && log.isInfoEnabled()) {
                    log.info((Object)"No failovers defined, exiting failover runner.");
                    return;
                }
                int fidx = this.facade.getRemoteCacheAttributes().getFailoverIndex();
                log.debug((Object)("fidx = " + fidx + " failovers.length = " + failovers.length));
                int i = fidx;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("stating at failover i = " + i));
                }
                while (i < failovers.length && !this.alright) {
                    block26: {
                        String server = failovers[i];
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Trying server [" + server + "] at failover index i = " + i));
                        }
                        RemoteCacheAttributes rca = null;
                        try {
                            RemoteCacheNoWait ic;
                            rca = (RemoteCacheAttributes)this.facade.getRemoteCacheAttributes().copy();
                            RemoteUtils.parseServerAndPort(server, rca);
                            RemoteCacheManager rcm = RemoteCacheManager.getInstance(rca, this.cacheMgr, this.cacheEventLogger, this.elementSerializer);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("RemoteCacheAttributes for failover = " + rca.toString()));
                            }
                            if ((ic = rcm.getCache(rca.getCacheName())).getStatus() != CacheStatus.ALIVE) break block26;
                            log.debug((Object)"resetting no wait");
                            this.facade.noWaits = new RemoteCacheNoWait[1];
                            this.facade.noWaits[0] = ic;
                            this.facade.getRemoteCacheAttributes().setFailoverIndex(i);
                            RemoteCacheFailoverRunner remoteCacheFailoverRunner = this;
                            synchronized (remoteCacheFailoverRunner) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"setting ALRIGHT to true");
                                    if (i > 0) {
                                        log.debug((Object)("Moving to Primary Recovery Mode, failover index = " + i));
                                    } else if (log.isInfoEnabled()) {
                                        String message = "No need to connect to failover, the primary server is back up.";
                                        log.info((Object)message);
                                    }
                                }
                                this.alright = true;
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("CONNECTED to host = [" + rca.getRemoteHost() + "] port = [" + rca.getRemotePort() + "]"));
                                }
                            }
                        }
                        catch (Exception ex) {
                            int remotePort;
                            this.bad();
                            String remoteHost = rca == null ? "null" : rca.getRemoteHost();
                            int n = remotePort = rca == null ? 0 : rca.getRemotePort();
                            if (i == 0) {
                                log.warn((Object)("FAILED to connect, as expected, to primary" + remoteHost + ":" + remotePort), (Throwable)ex);
                            }
                            log.error((Object)("FAILED to connect to failover [" + remoteHost + ":" + remotePort + "]"), (Throwable)ex);
                        }
                    }
                    ++i;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"ALRIGHT is true ");
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Failover runner is in primary recovery mode. Failover index = " + this.facade.getRemoteCacheAttributes().getFailoverIndex() + "\n" + "Will now try to reconnect to primary server."));
                }
            }
            boolean primaryRestoredSuccessfully = false;
            if (this.facade.getRemoteCacheAttributes().getFailoverIndex() > 0) {
                primaryRestoredSuccessfully = this.restorePrimary();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Primary recovery success state = " + primaryRestoredSuccessfully));
                }
            }
            if (primaryRestoredSuccessfully) continue;
            try {
                log.warn((Object)("Failed to reconnect to primary server. Cache failover runner is going to sleep for " + idlePeriod + " milliseconds."));
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.facade.getRemoteCacheAttributes().getFailoverIndex() > 0 || !this.alright);
    }

    private boolean restorePrimary() {
        String[] failovers = this.facade.getRemoteCacheAttributes().getFailovers();
        String server = failovers[0];
        if (log.isInfoEnabled()) {
            log.info((Object)("Trying to restore connection to primary remote server [" + server + "]"));
        }
        try {
            RemoteCacheAttributes rca = (RemoteCacheAttributes)this.facade.getRemoteCacheAttributes().copy();
            RemoteUtils.parseServerAndPort(server, rca);
            RemoteCacheManager rcm = RemoteCacheManager.getInstance(rca, this.cacheMgr, this.cacheEventLogger, this.elementSerializer);
            RemoteCacheNoWait ic = rcm.getCache(rca.getCacheName());
            if (ic.getStatus() == CacheStatus.ALIVE) {
                try {
                    if (this.facade.noWaits[0] != null && this.facade.noWaits[0].getStatus() == CacheStatus.ALIVE) {
                        int fidx = this.facade.getRemoteCacheAttributes().getFailoverIndex();
                        if (fidx > 0) {
                            String serverOld = failovers[fidx];
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Failover Index = " + fidx + " the server at that index is [" + serverOld + "]"));
                            }
                            if (serverOld != null) {
                                RemoteCacheAttributes rcaOld = (RemoteCacheAttributes)this.facade.getRemoteCacheAttributes().copy();
                                RemoteUtils.parseServerAndPort(serverOld, rcaOld);
                                RemoteCacheManager rcmOld = RemoteCacheManager.getInstance(rcaOld, this.cacheMgr, this.cacheEventLogger, this.elementSerializer);
                                if (rcmOld != null) {
                                    rcmOld.removeRemoteCacheListener(rcaOld);
                                }
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("Successfully deregistered from FAILOVER remote server = " + serverOld));
                                }
                            }
                        } else if (fidx == 0) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"No need to restore primary, it is already restored.");
                                return true;
                            }
                        } else if (fidx < 0) {
                            log.warn((Object)"Failover index is less than 0, this shouldn't happen");
                        }
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Trouble trying to deregister old failover listener prior to restoring the primary = " + server), (Throwable)e);
                }
                RemoteCacheNoWait failoverNoWait = this.facade.noWaits[0];
                this.facade.noWaits = new RemoteCacheNoWait[1];
                this.facade.noWaits[0] = ic;
                this.facade.getRemoteCacheAttributes().setFailoverIndex(0);
                if (log.isInfoEnabled()) {
                    String message = "Successfully reconnected to PRIMARY remote server.  Substituted primary for failoverNoWait [" + failoverNoWait + "]";
                    log.info((Object)message);
                    if (this.facade.getCacheEventLogger() != null) {
                        this.facade.getCacheEventLogger().logApplicationEvent("RemoteCacheFailoverRunner", "RestoredPrimary", message);
                    }
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Primary server status in error, not connected.");
            }
        }
        catch (NumberFormatException ex) {
            log.error((Object)ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bad() {
        if (this.alright) {
            RemoteCacheFailoverRunner remoteCacheFailoverRunner = this;
            synchronized (remoteCacheFailoverRunner) {
                this.alright = false;
            }
        }
    }
}

