/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.io.IOException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jcs.auxiliary.remote.RemoteCache;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheListener;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheMonitor;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheClient;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs.engine.CacheWatchRepairable;
import org.apache.commons.jcs.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs.engine.ZombieCacheWatch;
import org.apache.commons.jcs.engine.behavior.ICache;
import org.apache.commons.jcs.engine.behavior.ICacheObserver;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.behavior.IShutdownObserver;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheManager
implements IShutdownObserver {
    private static final Log log = LogFactory.getLog(RemoteCacheManager.class);
    static final Map<Location, RemoteCacheManager> instances = new HashMap<Location, RemoteCacheManager>();
    private static RemoteCacheMonitor monitor;
    private int clients;
    final Map<String, RemoteCacheNoWait<?, ?>> caches = new HashMap();
    final String host;
    final int port;
    final String service;
    private IRemoteCacheAttributes remoteCacheAttributes;
    private final ICacheEventLogger cacheEventLogger;
    private final IElementSerializer elementSerializer;
    private ICacheServiceNonLocal<?, ?> remoteService;
    private CacheWatchRepairable remoteWatch;
    private final ICompositeCacheManager cacheMgr;

    private RemoteCacheManager(String host, int port, String service, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        this.host = host;
        this.port = port;
        this.service = service;
        this.cacheMgr = cacheMgr;
        this.cacheEventLogger = cacheEventLogger;
        this.elementSerializer = elementSerializer;
        this.cacheMgr.registerShutdownObserver(this);
        String registry = RemoteUtils.getNamingURL(host, port, service);
        if (log.isInfoEnabled()) {
            log.info((Object)("Looking up server [" + registry + "]"));
        }
        try {
            Remote obj = Naming.lookup(registry);
            if (log.isInfoEnabled()) {
                log.info((Object)("Server found: " + obj));
            }
            this.remoteService = (ICacheServiceNonLocal)obj;
            if (log.isDebugEnabled()) {
                log.debug((Object)("remoteService = " + this.remoteService));
            }
            ICacheObserver remoteObserver = (ICacheObserver)((Object)obj);
            this.remoteWatch = new CacheWatchRepairable();
            this.remoteWatch.setCacheWatch(remoteObserver);
        }
        catch (Exception ex) {
            log.error((Object)("Problem finding server at [" + registry + "]"), (Throwable)ex);
            this.remoteService = new ZombieCacheServiceNonLocal();
            this.remoteWatch = new CacheWatchRepairable();
            this.remoteWatch.setCacheWatch(new ZombieCacheWatch());
            RemoteCacheMonitor.getInstance().notifyError();
        }
    }

    public IRemoteCacheAttributes getDefaultCattr() {
        return this.remoteCacheAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void addRemoteCacheListener(IRemoteCacheAttributes cattr, IRemoteCacheListener<K, V> listener) throws IOException {
        if (cattr.isReceive()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("The remote cache is configured to receive events from the remote server.  We will register a listener. remoteWatch = " + this.remoteWatch + " | IRemoteCacheListener = " + listener + " | cacheName " + cattr.getCacheName()));
            }
            Map<String, RemoteCacheNoWait<?, ?>> map = this.caches;
            synchronized (map) {
                this.remoteWatch.addCacheListener(cattr.getCacheName(), listener);
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"The remote cache is configured to NOT receive events from the remote server.  We will NOT register a listener.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void removeRemoteCacheListener(IRemoteCacheAttributes cattr, IRemoteCacheListener<K, V> listener) throws IOException {
        Map<String, RemoteCacheNoWait<?, ?>> map = this.caches;
        synchronized (map) {
            this.remoteWatch.removeCacheListener(cattr.getCacheName(), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteCacheListener(IRemoteCacheAttributes cattr) throws IOException {
        Map<String, RemoteCacheNoWait<?, ?>> map = this.caches;
        synchronized (map) {
            RemoteCacheNoWait<?, ?> cache = this.caches.get(cattr.getCacheName());
            if (cache != null) {
                IRemoteCacheClient<?, ?> rc = cache.getRemoteCache();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found cache for[ " + cattr.getCacheName() + "], deregistering listener."));
                }
                IRemoteCacheListener<?, ?> listener = rc.getListener();
                this.remoteWatch.removeCacheListener(cattr.getCacheName(), listener);
            } else if (cattr.isReceive()) {
                log.warn((Object)"Trying to deregister Cache Listener that was never registered.");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Since the remote cache is configured to not receive, there is no listener to deregister.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteCacheListener(String cacheName) throws IOException {
        Map<String, RemoteCacheNoWait<?, ?>> map = this.caches;
        synchronized (map) {
            RemoteCacheNoWait<?, ?> cache = this.caches.get(cacheName);
            if (cache != null) {
                IRemoteCacheClient<?, ?> rc = cache.getRemoteCache();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found cache for [" + cacheName + "], deregistering listener."));
                }
                IRemoteCacheListener<?, ?> listener = rc.getListener();
                this.remoteWatch.removeCacheListener(cacheName, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteCacheManager getInstance(IRemoteCacheAttributes cattr, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        String host = cattr.getRemoteHost();
        int port = cattr.getRemotePort();
        String service = cattr.getRemoteServiceName();
        if (host == null) {
            host = "";
        }
        if (port < 1024) {
            port = 1099;
        }
        Location loc = new Location(host, port);
        RemoteCacheManager ins = null;
        Map<Location, RemoteCacheManager> map = instances;
        synchronized (map) {
            ins = instances.get(loc);
            if (ins == null) {
                ins = new RemoteCacheManager(host, port, service, cacheMgr, cacheEventLogger, elementSerializer);
                ins.remoteCacheAttributes = cattr;
                instances.put(loc, ins);
            }
        }
        ++ins.clients;
        if (monitor == null && (monitor = RemoteCacheMonitor.getInstance()) != null) {
            Thread t = new Thread(monitor);
            t.setDaemon(true);
            t.start();
        }
        return ins;
    }

    public <K, V> RemoteCacheNoWait<K, V> getCache(String cacheName) {
        IRemoteCacheAttributes ca = (IRemoteCacheAttributes)this.remoteCacheAttributes.copy();
        ca.setCacheName(cacheName);
        return this.getCache(ca);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> RemoteCacheNoWait<K, V> getCache(IRemoteCacheAttributes cattr) {
        RemoteCacheNoWait<?, ?> remoteCacheNoWait = null;
        Map<String, RemoteCacheNoWait<?, ?>> map = this.caches;
        synchronized (map) {
            RemoteCacheNoWait<?, ?> remoteCacheNoWait2;
            remoteCacheNoWait = remoteCacheNoWait2 = this.caches.get(cattr.getCacheName());
            if (remoteCacheNoWait == null) {
                RemoteCacheListener listener = null;
                try {
                    listener = new RemoteCacheListener(cattr, this.cacheMgr);
                    this.addRemoteCacheListener(cattr, listener);
                }
                catch (IOException ioe) {
                    log.error((Object)("IOException. Problem adding listener. Message: " + ioe.getMessage() + " | RemoteCacheListener = " + listener), (Throwable)ioe);
                }
                catch (Exception e) {
                    log.error((Object)("Problem adding listener. Message: " + e.getMessage() + " | RemoteCacheListener = " + listener), (Throwable)e);
                }
                RemoteCache remoteCacheClient = new RemoteCache(cattr, this.remoteService, listener);
                remoteCacheClient.setCacheEventLogger(this.cacheEventLogger);
                remoteCacheClient.setElementSerializer(this.elementSerializer);
                remoteCacheNoWait = new RemoteCacheNoWait(remoteCacheClient);
                remoteCacheNoWait.setCacheEventLogger(this.cacheEventLogger);
                remoteCacheNoWait.setElementSerializer(this.elementSerializer);
                this.caches.put(cattr.getCacheName(), remoteCacheNoWait);
            }
        }
        return remoteCacheNoWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeCache(String name) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("freeCache [" + name + "]"));
        }
        ICache c = null;
        Map<String, RemoteCacheNoWait<?, ?>> map = this.caches;
        synchronized (map) {
            c = this.caches.get(name);
        }
        if (c != null) {
            this.removeRemoteCacheListener(name);
            c.dispose();
        }
    }

    public String getStats() {
        StringBuilder stats = new StringBuilder();
        for (RemoteCacheNoWait<?, ?> c : this.caches.values()) {
            if (c == null) continue;
            stats.append(c.getCacheName());
        }
        return stats.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (--this.clients != 0) {
            return;
        }
        Map<String, RemoteCacheNoWait<?, ?>> map = this.caches;
        synchronized (map) {
            for (RemoteCacheNoWait<?, ?> c : this.caches.values()) {
                if (c == null) continue;
                try {
                    this.freeCache(c.getCacheName());
                }
                catch (IOException ex) {
                    log.error((Object)"Problem in release.", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixCaches(ICacheServiceNonLocal<?, ?> remoteService, ICacheObserver remoteWatch) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Fixing caches. ICacheServiceNonLocal " + remoteService + " | IRemoteCacheObserver " + remoteWatch));
        }
        Map<String, RemoteCacheNoWait<?, ?>> map = this.caches;
        synchronized (map) {
            this.remoteService = remoteService;
            this.remoteWatch.setCacheWatch(remoteWatch);
            for (RemoteCacheNoWait<?, ?> c : this.caches.values()) {
                c.fixCache(remoteService);
            }
        }
    }

    @Override
    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Observed shutdown request.");
        }
        this.release();
    }

    protected void logApplicationEvent(String source, String eventName, String optionalDetails) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logApplicationEvent(source, eventName, optionalDetails);
        }
    }

    private static final class Location {
        public final String host;
        public final int port;

        public Location(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof Location)) {
                return false;
            }
            Location l = (Location)obj;
            if (this.host == null) {
                return l.host == null && this.port == l.port;
            }
            return this.host.equals(l.host) && this.port == l.port;
        }

        public int hashCode() {
            return this.host == null ? this.port : this.host.hashCode() ^ this.port;
        }
    }
}

