/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.utils.net.HostNameUtil;
import org.apache.commons.jcs.utils.props.PropertyLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheStartupServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RemoteCacheStartupServlet.class);
    private static final int DEFAULT_REGISTRY_PORT = 1101;
    private static final String DEFAULT_PROPS_FILE_NAME = "cache";
    private static final String DEFAULT_PROPS_FILE_SUFFIX = "ccf";
    private final String propsFileName = "cache";
    private final String fullPropsFileName = "cache.ccf";

    public void init() throws ServletException {
        super.init();
        int registryPort = 1101;
        Properties props = PropertyLoader.loadProperties(DEFAULT_PROPS_FILE_NAME);
        if (props != null) {
            String portS = props.getProperty("registry.port", String.valueOf(1101));
            try {
                registryPort = Integer.parseInt(portS);
            }
            catch (NumberFormatException e) {
                log.error((Object)"Problem converting port to an int.", (Throwable)e);
            }
        }
        try {
            String registryHost = HostNameUtil.getLocalHostAddress();
            if (log.isDebugEnabled()) {
                log.debug((Object)("registryHost = [" + registryHost + "]"));
            }
            if ("localhost".equals(registryHost) || "127.0.0.1".equals(registryHost)) {
                log.warn((Object)("The local address [" + registryHost + "] is INVALID.  Other machines must be able to use the address to reach this server."));
            }
            try {
                RemoteCacheServerFactory.startup(registryHost, registryPort, "/cache.ccf");
                if (log.isInfoEnabled()) {
                    log.info((Object)"Remote JCS Server started with properties from cache.ccf");
                }
            }
            catch (IOException e) {
                log.error((Object)"Problem starting remote cache server.", (Throwable)e);
            }
        }
        catch (UnknownHostException e) {
            log.error((Object)"Could not get local address to use for the registry!", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String stats = "";
        try {
            stats = CompositeCacheManager.getInstance().getStats();
        }
        catch (CacheException e) {
            throw new ServletException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)stats);
        }
        try {
            String characterEncoding = response.getCharacterEncoding();
            if (characterEncoding == null) {
                characterEncoding = "UTF-8";
                response.setCharacterEncoding(characterEncoding);
            }
            ServletOutputStream os = response.getOutputStream();
            os.write(stats.getBytes(characterEncoding));
            os.close();
        }
        catch (IOException e) {
            log.error((Object)"Problem writing response.", (Throwable)e);
        }
    }

    public void destroy() {
        super.destroy();
        log.info((Object)"Shutting down remote cache ");
        try {
            CompositeCacheManager.getInstance().shutDown();
        }
        catch (CacheException e) {
            log.error((Object)"Could not retrieve cache manager instance", (Throwable)e);
        }
    }
}

