/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.memory.AbstractMemoryCache;
import org.apache.commons.jcs.engine.memory.util.MemoryElementDescriptor;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.struct.DoubleLinkedList;
import org.apache.commons.jcs.utils.struct.DoubleLinkedListNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDoubleLinkedListMemoryCache<K, V>
extends AbstractMemoryCache<K, V> {
    private static final Log log = LogFactory.getLog(AbstractDoubleLinkedListMemoryCache.class);
    protected DoubleLinkedList<MemoryElementDescriptor<K, V>> list;
    private volatile int hitCnt = 0;
    private volatile int missCnt = 0;
    private volatile int putCnt = 0;

    @Override
    public void initialize(CompositeCache<K, V> hub) {
        this.lock.lock();
        try {
            super.initialize(hub);
            this.list = new DoubleLinkedList();
            log.info((Object)("initialized MemoryCache for " + this.cacheName));
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Map<K, MemoryElementDescriptor<K, V>> createMap() {
        return new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void update(ICacheElement<K, V> ce) throws IOException {
        this.lock.lock();
        try {
            ++this.putCnt;
            MemoryElementDescriptor<K, V> newNode = this.adjustListForUpdate(ce);
            MemoryElementDescriptor<K, V> oldNode = this.map.put(newNode.ce.getKey(), newNode);
            if (oldNode != null && newNode.ce.getKey().equals(oldNode.ce.getKey())) {
                this.list.remove(oldNode);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.spoolIfNeeded();
    }

    protected abstract MemoryElementDescriptor<K, V> adjustListForUpdate(ICacheElement<K, V> var1) throws IOException;

    private void spoolIfNeeded() throws Error {
        int size = this.map.size();
        if (size <= this.cacheAttributes.getMaxObjects()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"In memory limit reached, spooling");
        }
        int chunkSizeCorrected = Math.min(size, this.chunkSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to spool to disk cache, map size: " + size + ", max objects: " + this.cacheAttributes.getMaxObjects() + ", items to spool: " + chunkSizeCorrected));
        }
        for (int i = 0; i < chunkSizeCorrected; ++i) {
            this.spoolLastElement();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("update: After spool map size: " + this.map.size() + " linked list size = " + this.dumpCacheSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICacheElement<K, V> get(K key) throws IOException {
        MemoryElementDescriptor me;
        ICacheElement ce = null;
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debug((Object)("getting item from cache " + this.cacheName + " for key " + key));
        }
        if ((me = (MemoryElementDescriptor)this.map.get(key)) != null) {
            this.lock.lock();
            try {
                ce = me.ce;
                ++this.hitCnt;
                this.adjustListForGet(me);
            }
            finally {
                this.lock.unlock();
            }
            if (debugEnabled) {
                log.debug((Object)(this.cacheName + ": LRUMemoryCache hit for " + ce.getKey()));
            }
        } else {
            this.lock.lock();
            try {
                ++this.missCnt;
            }
            finally {
                this.lock.unlock();
            }
            if (debugEnabled) {
                log.debug((Object)(this.cacheName + ": LRUMemoryCache miss for " + key));
            }
        }
        this.verifyCache();
        return ce;
    }

    protected abstract void adjustListForGet(MemoryElementDescriptor<K, V> var1);

    @Override
    public int freeElements(int numberToFree) throws IOException {
        ICacheElement<K, V> element;
        int freed;
        for (freed = 0; freed < numberToFree && (element = this.spoolLastElement()) != null; ++freed) {
        }
        return freed;
    }

    protected ICacheElement<K, V> spoolLastElement() throws Error {
        ICacheElement toSpool = null;
        MemoryElementDescriptor<K, V> last = this.list.getLast();
        if (last != null) {
            this.lock.lock();
            try {
                toSpool = last.ce;
                if (toSpool != null) {
                    this.cache.spoolToDisk(last.ce);
                    if (this.map.remove(last.ce.getKey()) == null) {
                        log.warn((Object)("update: remove failed for key: " + last.ce.getKey()));
                        this.verifyCache();
                    }
                } else {
                    throw new Error("update: last.ce is null!");
                }
                this.list.remove(last);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.verifyCache();
            throw new Error("update: last is null!");
        }
        if (this.map.size() != this.dumpCacheSize()) {
            log.warn((Object)("update: After spool, size mismatch: map.size() = " + this.map.size() + ", linked list size = " + this.dumpCacheSize()));
        }
        return toSpool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean remove(K key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing item for key: " + key));
        }
        boolean removed = false;
        if (key instanceof String && ((String)key).endsWith(":")) {
            Iterator itr = this.map.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                Object k = entry.getKey();
                if (!(k instanceof String) || !((String)k).startsWith(key.toString())) continue;
                this.lock.lock();
                try {
                    this.list.remove((MemoryElementDescriptor<K, V>)((DoubleLinkedListNode)entry.getValue()));
                    itr.remove();
                    removed = true;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return removed;
        } else if (key instanceof GroupAttrName && ((GroupAttrName)key).attrName == null) {
            Iterator itr = this.map.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                Object k = entry.getKey();
                if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(((GroupAttrName)key).groupId)) continue;
                this.lock.lock();
                try {
                    this.list.remove((MemoryElementDescriptor<K, V>)((DoubleLinkedListNode)entry.getValue()));
                    itr.remove();
                    removed = true;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return removed;
        } else {
            this.lock.lock();
            try {
                MemoryElementDescriptor me = (MemoryElementDescriptor)this.map.remove(key);
                if (me == null) return removed;
                this.list.remove(me);
                removed = true;
                return removed;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void removeAll() throws IOException {
        this.lock.lock();
        try {
            this.list.removeAll();
            this.map.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemoryElementDescriptor<K, V> addFirst(ICacheElement<K, V> ce) {
        this.lock.lock();
        try {
            MemoryElementDescriptor<K, V> me = new MemoryElementDescriptor<K, V>(ce);
            this.list.addFirst(me);
            this.verifyCache(ce.getKey());
            MemoryElementDescriptor<K, V> memoryElementDescriptor = me;
            return memoryElementDescriptor;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemoryElementDescriptor<K, V> addLast(ICacheElement<K, V> ce) {
        this.lock.lock();
        try {
            MemoryElementDescriptor<K, V> me = new MemoryElementDescriptor<K, V>(ce);
            this.list.addLast(me);
            this.verifyCache(ce.getKey());
            MemoryElementDescriptor<K, V> memoryElementDescriptor = me;
            return memoryElementDescriptor;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void dumpCacheEntries() {
        log.debug((Object)"dumpingCacheEntries");
        MemoryElementDescriptor me = this.list.getFirst();
        while (me != null) {
            log.debug((Object)("dumpCacheEntries> key=" + me.ce.getKey() + ", val=" + me.ce.getVal()));
            me = (MemoryElementDescriptor)me.next;
        }
    }

    protected int dumpCacheSize() {
        return this.list.size();
    }

    protected void verifyCache() {
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean found = false;
        log.debug((Object)("verifycache[" + this.cacheName + "]: mapContains " + this.map.size() + " elements, linked list contains " + this.dumpCacheSize() + " elements"));
        log.debug((Object)"verifycache: checking linked list by key ");
        MemoryElementDescriptor li = this.list.getFirst();
        while (li != null) {
            Object key = li.ce.getKey();
            if (!this.map.containsKey(key)) {
                log.error((Object)("verifycache[" + this.cacheName + "]: map does not contain key : " + li.ce.getKey()));
                log.error((Object)("li.hashcode=" + li.ce.getKey().hashCode()));
                log.error((Object)("key class=" + key.getClass()));
                log.error((Object)("key hashcode=" + key.hashCode()));
                log.error((Object)("key toString=" + key.toString()));
                if (key instanceof GroupAttrName) {
                    GroupAttrName name = (GroupAttrName)key;
                    log.error((Object)("GroupID hashcode=" + name.groupId.hashCode()));
                    log.error((Object)("GroupID.class=" + name.groupId.getClass()));
                    log.error((Object)("AttrName hashcode=" + name.attrName.hashCode()));
                    log.error((Object)("AttrName.class=" + name.attrName.getClass()));
                }
                this.dumpMap();
            } else if (this.map.get(li.ce.getKey()) == null) {
                log.error((Object)("verifycache[" + this.cacheName + "]: linked list retrieval returned null for key: " + li.ce.getKey()));
            }
            li = (MemoryElementDescriptor)li.next;
        }
        log.debug((Object)"verifycache: checking linked list by value ");
        MemoryElementDescriptor li3 = this.list.getFirst();
        while (li3 != null) {
            if (!this.map.containsValue(li3)) {
                log.error((Object)("verifycache[" + this.cacheName + "]: map does not contain value : " + li3));
                this.dumpMap();
            }
            li3 = (MemoryElementDescriptor)li3.next;
        }
        log.debug((Object)"verifycache: checking via keysets!");
        for (Object val : this.map.keySet()) {
            found = false;
            MemoryElementDescriptor li2 = this.list.getFirst();
            while (li2 != null) {
                if (val.equals(li2.ce.getKey())) {
                    found = true;
                    break;
                }
                li2 = (MemoryElementDescriptor)li2.next;
            }
            if (found) continue;
            log.error((Object)("verifycache[" + this.cacheName + "]: key not found in list : " + val));
            this.dumpCacheEntries();
            if (this.map.containsKey(val)) {
                log.error((Object)"verifycache: map contains key");
                continue;
            }
            log.error((Object)"verifycache: map does NOT contain key, what the HECK!");
        }
    }

    private void verifyCache(K key) {
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean found = false;
        MemoryElementDescriptor li = this.list.getFirst();
        while (li != null) {
            if (li.ce.getKey() == key) {
                found = true;
                log.debug((Object)("verifycache(key) key match: " + key));
                break;
            }
            li = (MemoryElementDescriptor)li.next;
        }
        if (!found) {
            log.error((Object)("verifycache(key)[" + this.cacheName + "], couldn't find key! : " + key));
        }
    }

    @Override
    public Set<K> getKeySet() {
        return new LinkedHashSet(this.map.keySet());
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Memory Cache");
        ArrayList elems = new ArrayList();
        this.lock.lock();
        try {
            elems.add(new StatElement<Integer>("List Size", this.list.size()));
            elems.add(new StatElement<Integer>("Map Size", this.map.size()));
            elems.add(new StatElement<Integer>("Put Count", this.putCnt));
            elems.add(new StatElement<Integer>("Hit Count", this.hitCnt));
            elems.add(new StatElement<Integer>("Miss Count", this.missCnt));
        }
        finally {
            this.lock.unlock();
        }
        stats.setStatElements(elems);
        return stats;
    }

    public static class MapEntryWrapper<K extends Serializable, V extends Serializable>
    implements Map.Entry<K, ICacheElement<K, V>> {
        private final Map.Entry<K, MemoryElementDescriptor<K, V>> e;

        private MapEntryWrapper(Map.Entry<K, MemoryElementDescriptor<K, V>> e) {
            this.e = e;
        }

        @Override
        public boolean equals(Object o) {
            return this.e.equals(o);
        }

        @Override
        public K getKey() {
            return (K)((Serializable)this.e.getKey());
        }

        @Override
        public ICacheElement<K, V> getValue() {
            return this.e.getValue().ce;
        }

        @Override
        public int hashCode() {
            return this.e.hashCode();
        }

        @Override
        public ICacheElement<K, V> setValue(ICacheElement<K, V> value) {
            throw new UnsupportedOperationException("Use normal cache methods to alter the contents of the cache.");
        }
    }

    public static class IteratorWrapper<K extends Serializable, V extends Serializable>
    implements Iterator<Map.Entry<K, MemoryElementDescriptor<K, V>>> {
        private final Iterator<Map.Entry<K, MemoryElementDescriptor<K, V>>> i;

        protected IteratorWrapper(Map<K, MemoryElementDescriptor<K, V>> m) {
            this.i = m.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Map.Entry<K, MemoryElementDescriptor<K, V>> next() {
            return this.i.next();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        public boolean equals(Object o) {
            return this.i.equals(o);
        }

        public int hashCode() {
            return this.i.hashCode();
        }
    }
}

