/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.struct;

import org.apache.commons.jcs.utils.struct.DoubleLinkedList;
import org.apache.commons.jcs.utils.struct.DoubleLinkedListNode;

public class BoundedQueue<T> {
    private final int maxSize;
    private final DoubleLinkedList<DoubleLinkedListNode<T>> list = new DoubleLinkedList();

    public BoundedQueue(int maxSize) {
        this.maxSize = maxSize;
    }

    public void add(T object) {
        if (this.list.size() >= this.maxSize) {
            this.list.removeLast();
        }
        this.list.addFirst(new DoubleLinkedListNode<T>(object));
    }

    public T take() {
        DoubleLinkedListNode<T> node = this.list.removeLast();
        if (node != null) {
            return node.getPayload();
        }
        return null;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.size() <= 0;
    }
}

