/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.threadpool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.utils.props.PropertyLoader;
import org.apache.commons.jcs.utils.threadpool.DaemonThreadFactory;
import org.apache.commons.jcs.utils.threadpool.PoolConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadPoolManager {
    private static final Log log = LogFactory.getLog(ThreadPoolManager.class);
    private static boolean useBoundary_DEFAULT = true;
    private static int boundarySize_DEFAULT = 2000;
    private static int maximumPoolSize_DEFAULT = 150;
    private static int minimumPoolSize_DEFAULT = 4;
    private static int keepAliveTime_DEFAULT = 300000;
    private static PoolConfiguration.WhenBlockedPolicy whenBlockedPolicy_DEFAULT = PoolConfiguration.WhenBlockedPolicy.RUN;
    private static int startUpSize_DEFAULT = 4;
    private static PoolConfiguration defaultConfig;
    private static String propsFileName;
    private static final String PROP_NAME_ROOT = "thread_pool";
    private static final String DEFAULT_PROP_NAME_ROOT = "thread_pool.default";
    private static volatile Properties props;
    private static HashMap<String, ThreadPoolExecutor> pools;
    private static ThreadPoolManager INSTANCE;

    private ThreadPoolManager() {
        this.configure();
    }

    private ThreadPoolExecutor createPool(PoolConfiguration config) {
        ThreadPoolExecutor pool = null;
        LinkedBlockingQueue<Runnable> queue = null;
        if (config.isUseBoundary()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating a Bounded Buffer to use for the pool");
            }
            queue = new LinkedBlockingQueue(config.getBoundarySize());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating a non bounded Linked Queue to use for the pool");
            }
            queue = new LinkedBlockingQueue<Runnable>();
        }
        pool = new ThreadPoolExecutor(config.getStartUpSize(), config.getMaximumPoolSize(), (long)config.getKeepAliveTime(), TimeUnit.MILLISECONDS, queue, new DaemonThreadFactory("JCS-ThreadPoolManager-"));
        switch (config.getWhenBlockedPolicy()) {
            case ABORT: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
                break;
            }
            case RUN: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                break;
            }
            case WAIT: {
                throw new RuntimeException("POLICY_WAIT no longer supported");
            }
            case DISCARDOLDEST: {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
                break;
            }
        }
        pool.prestartAllCoreThreads();
        return pool;
    }

    public static synchronized ThreadPoolManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ThreadPoolManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            for (String poolName : INSTANCE.getPoolNames()) {
                try {
                    INSTANCE.getPool(poolName).shutdownNow();
                }
                catch (Throwable t) {
                    log.warn((Object)("Failed to close pool " + poolName), t);
                }
            }
            INSTANCE = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolExecutor getPool(String name) {
        ThreadPoolExecutor pool = null;
        HashMap<String, ThreadPoolExecutor> hashMap = pools;
        synchronized (hashMap) {
            pool = pools.get(name);
            if (pool == null) {
                PoolConfiguration config;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating pool for name [" + name + "]"));
                }
                if ((pool = this.createPool(config = this.loadConfig("thread_pool." + name))) != null) {
                    pools.put(name, pool);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PoolName = " + this.getPoolNames()));
                }
            }
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getPoolNames() {
        ArrayList<String> poolNames = new ArrayList<String>();
        HashMap<String, ThreadPoolExecutor> hashMap = pools;
        synchronized (hashMap) {
            poolNames.addAll(pools.keySet());
        }
        return poolNames;
    }

    public static void setPropsFileName(String propsFileName) {
        ThreadPoolManager.propsFileName = propsFileName;
    }

    public static String getPropsFileName() {
        return propsFileName;
    }

    public static void setProps(Properties props) {
        ThreadPoolManager.props = props;
    }

    public static Properties getProps() {
        return props;
    }

    protected void configure() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing ThreadPoolManager");
        }
        if (props == null) {
            try {
                props = PropertyLoader.loadProperties(propsFileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("File contained " + props.size() + " properties"));
                }
            }
            catch (Exception e) {
                log.error((Object)("Problem loading properties. propsFileName [" + propsFileName + "]"), (Throwable)e);
            }
        }
        if (props == null) {
            log.warn((Object)"No configuration settings found.  Using hardcoded default values for all pools.");
            props = new Properties();
        }
        defaultConfig = new PoolConfiguration(useBoundary_DEFAULT, boundarySize_DEFAULT, maximumPoolSize_DEFAULT, minimumPoolSize_DEFAULT, keepAliveTime_DEFAULT, whenBlockedPolicy_DEFAULT, startUpSize_DEFAULT);
        defaultConfig = this.loadConfig(DEFAULT_PROP_NAME_ROOT);
    }

    protected PoolConfiguration loadConfig(String root) {
        PoolConfiguration config = (PoolConfiguration)defaultConfig.clone();
        if (props.containsKey(root + ".useBoundary")) {
            try {
                config.setUseBoundary(Boolean.valueOf((String)props.get(root + ".useBoundary")));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"useBoundary not a boolean.", (Throwable)nfe);
            }
        }
        if (props.containsKey(root + ".boundarySize")) {
            try {
                config.setBoundarySize(Integer.parseInt((String)props.get(root + ".boundarySize")));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"boundarySize not a number.", (Throwable)nfe);
            }
        }
        if (props.containsKey(root + ".maximumPoolSize")) {
            try {
                config.setMaximumPoolSize(Integer.parseInt((String)props.get(root + ".maximumPoolSize")));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"maximumPoolSize not a number.", (Throwable)nfe);
            }
        }
        if (props.containsKey(root + ".minimumPoolSize")) {
            try {
                config.setMinimumPoolSize(Integer.parseInt((String)props.get(root + ".minimumPoolSize")));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"minimumPoolSize not a number.", (Throwable)nfe);
            }
        }
        if (props.containsKey(root + ".keepAliveTime")) {
            try {
                config.setKeepAliveTime(Integer.parseInt((String)props.get(root + ".keepAliveTime")));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"keepAliveTime not a number.", (Throwable)nfe);
            }
        }
        if (props.containsKey(root + ".whenBlockedPolicy")) {
            config.setWhenBlockedPolicy((String)props.get(root + ".whenBlockedPolicy"));
        }
        if (props.containsKey(root + ".startUpSize")) {
            try {
                config.setStartUpSize(Integer.parseInt((String)props.get(root + ".startUpSize")));
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"startUpSize not a number.", (Throwable)nfe);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(root + " PoolConfiguration = " + config));
        }
        return config;
    }

    static {
        propsFileName = null;
        props = null;
        pools = new HashMap();
        INSTANCE = null;
    }
}

