/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import org.apache.commons.jexl2.Debugger;
import org.apache.commons.jexl2.JexlInfo;
import org.apache.commons.jexl2.parser.JexlNode;

public class JexlException
extends RuntimeException {
    private static final long serialVersionUID = 2690666400232612395L;
    protected final JexlNode mark;
    protected final JexlInfo info;
    public static final String NULL_OPERAND = "jexl.null";

    public JexlException(JexlNode node, String msg) {
        super(msg);
        this.mark = node;
        this.info = node != null ? node.getInfo() : null;
    }

    public JexlException(JexlNode node, String msg, Throwable cause) {
        super(msg, cause);
        this.mark = node;
        this.info = node != null ? node.getInfo() : null;
    }

    public JexlException(JexlInfo dbg, String msg) {
        super(msg);
        this.mark = null;
        this.info = dbg;
    }

    public JexlException(JexlInfo dbg, String msg, Throwable cause) {
        super(msg, cause);
        this.mark = null;
        this.info = dbg;
    }

    public String getInfo(int[] offsets) {
        Debugger dbg = new Debugger();
        if (dbg.debug(this.mark)) {
            if (offsets != null && offsets.length >= 2) {
                offsets[0] = dbg.start();
                offsets[1] = dbg.end();
            }
            return dbg.data();
        }
        return "";
    }

    public String getMessage() {
        Debugger dbg = new Debugger();
        StringBuilder msg = new StringBuilder();
        if (this.info != null) {
            msg.append(this.info.debugString());
        }
        if (dbg.debug(this.mark)) {
            msg.append("![");
            msg.append(dbg.start());
            msg.append(",");
            msg.append(dbg.end());
            msg.append("]: '");
            msg.append(dbg.data());
            msg.append("' ");
        }
        msg.append(super.getMessage());
        Throwable cause = this.getCause();
        if (cause != null && NULL_OPERAND == cause.getMessage()) {
            msg.append(" caused by null operand");
        }
        return msg.toString();
    }
}

