/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.fitting.leastsquares;

import org.apache.commons.math4.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math4.linear.ArrayRealVector;
import org.apache.commons.math4.linear.DecompositionSolver;
import org.apache.commons.math4.linear.QRDecomposition;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.linear.RealVector;
import org.apache.commons.math4.util.FastMath;

public abstract class AbstractEvaluation
implements LeastSquaresProblem.Evaluation {
    private final int observationSize;

    AbstractEvaluation(int observationSize) {
        this.observationSize = observationSize;
    }

    @Override
    public RealMatrix getCovariances(double threshold) {
        RealMatrix j = this.getJacobian();
        RealMatrix jTj = j.transpose().multiply(j);
        DecompositionSolver solver = new QRDecomposition(jTj, threshold).getSolver();
        return solver.getInverse();
    }

    @Override
    public RealVector getSigma(double covarianceSingularityThreshold) {
        RealMatrix cov = this.getCovariances(covarianceSingularityThreshold);
        int nC = cov.getColumnDimension();
        ArrayRealVector sig = new ArrayRealVector(nC);
        for (int i = 0; i < nC; ++i) {
            ((RealVector)sig).setEntry(i, FastMath.sqrt(cov.getEntry(i, i)));
        }
        return sig;
    }

    @Override
    public double getRMS() {
        return FastMath.sqrt(this.getReducedChiSquare(1));
    }

    @Override
    public double getCost() {
        return FastMath.sqrt(this.getChiSquare());
    }

    @Override
    public double getChiSquare() {
        ArrayRealVector r = new ArrayRealVector(this.getResiduals());
        return r.dotProduct(r);
    }

    @Override
    public double getReducedChiSquare(int numberOfFittedParameters) {
        return this.getChiSquare() / (double)(this.observationSize - numberOfFittedParameters + 1);
    }
}

