/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.fitting.leastsquares;

import org.apache.commons.math4.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math4.optim.ConvergenceChecker;
import org.apache.commons.math4.util.Precision;

public class EvaluationRmsChecker
implements ConvergenceChecker<LeastSquaresProblem.Evaluation> {
    private final double relTol;
    private final double absTol;

    public EvaluationRmsChecker(double tol) {
        this(tol, tol);
    }

    public EvaluationRmsChecker(double relTol, double absTol) {
        this.relTol = relTol;
        this.absTol = absTol;
    }

    @Override
    public boolean converged(int iteration, LeastSquaresProblem.Evaluation previous, LeastSquaresProblem.Evaluation current) {
        double currRms;
        double prevRms = previous.getRMS();
        return Precision.equals(prevRms, currRms = current.getRMS(), this.absTol) || Precision.equalsWithRelativeTolerance(prevRms, currRms, this.relTol);
    }
}

