/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.random;

import java.util.Random;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.random.RandomGenerator;
import org.apache.commons.math4.random.RandomGeneratorFactory;

public class JDKRandomGenerator
implements RandomGenerator {
    private static final long serialVersionUID = 20151227L;
    private final Random delegate;

    public JDKRandomGenerator() {
        this.delegate = new Random();
    }

    public JDKRandomGenerator(long seed) {
        this.delegate = new Random(seed);
    }

    @Override
    public void setSeed(int seed) {
        this.delegate.setSeed(seed);
    }

    @Override
    public void setSeed(long seed) {
        this.delegate.setSeed(seed);
    }

    @Override
    public void setSeed(int[] seed) {
        this.delegate.setSeed(RandomGeneratorFactory.convertToLong(seed));
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.delegate.nextBytes(bytes);
    }

    @Override
    public int nextInt() {
        return this.delegate.nextInt();
    }

    @Override
    public long nextLong() {
        return this.delegate.nextLong();
    }

    @Override
    public boolean nextBoolean() {
        return this.delegate.nextBoolean();
    }

    @Override
    public float nextFloat() {
        return this.delegate.nextFloat();
    }

    @Override
    public double nextDouble() {
        return this.delegate.nextDouble();
    }

    @Override
    public double nextGaussian() {
        return this.delegate.nextGaussian();
    }

    @Override
    public int nextInt(int n) {
        try {
            return this.delegate.nextInt(n);
        }
        catch (IllegalArgumentException e) {
            throw new NotStrictlyPositiveException(n);
        }
    }
}

