/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.stat.interval;

import org.apache.commons.math4.distribution.FDistribution;
import org.apache.commons.math4.stat.interval.BinomialConfidenceInterval;
import org.apache.commons.math4.stat.interval.ConfidenceInterval;
import org.apache.commons.math4.stat.interval.IntervalUtils;

public class ClopperPearsonInterval
implements BinomialConfidenceInterval {
    @Override
    public ConfidenceInterval createInterval(int numberOfTrials, int numberOfSuccesses, double confidenceLevel) {
        IntervalUtils.checkParameters(numberOfTrials, numberOfSuccesses, confidenceLevel);
        double lowerBound = 0.0;
        double upperBound = 0.0;
        double alpha = (1.0 - confidenceLevel) / 2.0;
        FDistribution distributionLowerBound = new FDistribution(2 * (numberOfTrials - numberOfSuccesses + 1), 2 * numberOfSuccesses);
        if (numberOfSuccesses > 0) {
            double fValueLowerBound = distributionLowerBound.inverseCumulativeProbability(1.0 - alpha);
            lowerBound = (double)numberOfSuccesses / ((double)numberOfSuccesses + (double)(numberOfTrials - numberOfSuccesses + 1) * fValueLowerBound);
        }
        FDistribution distributionUpperBound = new FDistribution(2 * (numberOfSuccesses + 1), 2 * (numberOfTrials - numberOfSuccesses));
        if (numberOfSuccesses > 0) {
            double fValueUpperBound = distributionUpperBound.inverseCumulativeProbability(1.0 - alpha);
            upperBound = (double)(numberOfSuccesses + 1) * fValueUpperBound / ((double)(numberOfTrials - numberOfSuccesses) + (double)(numberOfSuccesses + 1) * fValueUpperBound);
        }
        return new ConfidenceInterval(lowerBound, upperBound, confidenceLevel);
    }
}

