/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.arrays;

public class LinearCombination {
    private LinearCombination() {
    }

    public static double value(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Dimension mismatch: " + a.length + " != " + b.length);
        }
        int len = a.length;
        if (len == 1) {
            return a[0] * b[0];
        }
        double[] prodHigh = new double[len];
        double prodLowSum = 0.0;
        for (int i = 0; i < len; ++i) {
            double ai = a[i];
            double aHigh = LinearCombination.highPart(ai);
            double aLow = ai - aHigh;
            double bi = b[i];
            double bHigh = LinearCombination.highPart(bi);
            double bLow = bi - bHigh;
            prodHigh[i] = ai * bi;
            double prodLow = LinearCombination.prodLow(aLow, bLow, prodHigh[i], aHigh, bHigh);
            prodLowSum += prodLow;
        }
        double prodHighCur = prodHigh[0];
        double prodHighNext = prodHigh[1];
        double sHighPrev = prodHighCur + prodHighNext;
        double sPrime = sHighPrev - prodHighNext;
        double sLowSum = prodHighNext - (sHighPrev - sPrime) + (prodHighCur - sPrime);
        int lenMinusOne = len - 1;
        for (int i = 1; i < lenMinusOne; ++i) {
            prodHighNext = prodHigh[i + 1];
            double sHighCur = sHighPrev + prodHighNext;
            sPrime = sHighCur - prodHighNext;
            sLowSum += prodHighNext - (sHighCur - sPrime) + (sHighPrev - sPrime);
            sHighPrev = sHighCur;
        }
        double result = sHighPrev + (prodLowSum + sLowSum);
        if (Double.isNaN(result)) {
            result = 0.0;
            for (int i = 0; i < len; ++i) {
                result += a[i] * b[i];
            }
        }
        return result;
    }

    public static double value(double a1, double b1, double a2, double b2) {
        double s12Prime;
        double s12Low;
        double b2High;
        double b2Low;
        double a2High;
        double a2Low;
        double prod2Low;
        double b1High;
        double b1Low;
        double prod1High = a1 * b1;
        double prod2High = a2 * b2;
        double s12High = prod1High + prod2High;
        double a1High = LinearCombination.highPart(a1);
        double a1Low = a1 - a1High;
        double prod1Low = LinearCombination.prodLow(a1Low, b1Low = b1 - (b1High = LinearCombination.highPart(b1)), prod1High, a1High, b1High);
        double result = s12High + (prod1Low + (prod2Low = LinearCombination.prodLow(a2Low = a2 - (a2High = LinearCombination.highPart(a2)), b2Low = b2 - (b2High = LinearCombination.highPart(b2)), prod2High, a2High, b2High)) + (s12Low = prod2High - (s12High - (s12Prime = s12High - prod2High)) + (prod1High - s12Prime)));
        if (Double.isNaN(result)) {
            result = a1 * b1 + a2 * b2;
        }
        return result;
    }

    public static double value(double a1, double b1, double a2, double b2, double a3, double b3) {
        double s123Prime;
        double s123Low;
        double s12Prime;
        double s12Low;
        double b3High;
        double b3Low;
        double a3High;
        double a3Low;
        double prod3Low;
        double b2High;
        double b2Low;
        double a2High;
        double a2Low;
        double prod2Low;
        double b1High;
        double b1Low;
        double prod1High = a1 * b1;
        double prod2High = a2 * b2;
        double s12High = prod1High + prod2High;
        double prod3High = a3 * b3;
        double s123High = s12High + prod3High;
        double a1High = LinearCombination.highPart(a1);
        double a1Low = a1 - a1High;
        double prod1Low = LinearCombination.prodLow(a1Low, b1Low = b1 - (b1High = LinearCombination.highPart(b1)), prod1High, a1High, b1High);
        double result = s123High + (prod1Low + (prod2Low = LinearCombination.prodLow(a2Low = a2 - (a2High = LinearCombination.highPart(a2)), b2Low = b2 - (b2High = LinearCombination.highPart(b2)), prod2High, a2High, b2High)) + (prod3Low = LinearCombination.prodLow(a3Low = a3 - (a3High = LinearCombination.highPart(a3)), b3Low = b3 - (b3High = LinearCombination.highPart(b3)), prod3High, a3High, b3High)) + (s12Low = prod2High - (s12High - (s12Prime = s12High - prod2High)) + (prod1High - s12Prime)) + (s123Low = prod3High - (s123High - (s123Prime = s123High - prod3High)) + (s12High - s123Prime)));
        if (Double.isNaN(result)) {
            result = a1 * b1 + a2 * b2 + a3 * b3;
        }
        return result;
    }

    public static double value(double a1, double b1, double a2, double b2, double a3, double b3, double a4, double b4) {
        double s1234Prime;
        double s1234Low;
        double s123Prime;
        double s123Low;
        double s12Prime;
        double s12Low;
        double b4High;
        double b4Low;
        double a4High;
        double a4Low;
        double prod4Low;
        double b3High;
        double b3Low;
        double a3High;
        double a3Low;
        double prod3Low;
        double b2High;
        double b2Low;
        double a2High;
        double a2Low;
        double prod2Low;
        double b1High;
        double b1Low;
        double prod1High = a1 * b1;
        double prod2High = a2 * b2;
        double s12High = prod1High + prod2High;
        double prod3High = a3 * b3;
        double s123High = s12High + prod3High;
        double prod4High = a4 * b4;
        double s1234High = s123High + prod4High;
        double a1High = LinearCombination.highPart(a1);
        double a1Low = a1 - a1High;
        double prod1Low = LinearCombination.prodLow(a1Low, b1Low = b1 - (b1High = LinearCombination.highPart(b1)), prod1High, a1High, b1High);
        double result = s1234High + (prod1Low + (prod2Low = LinearCombination.prodLow(a2Low = a2 - (a2High = LinearCombination.highPart(a2)), b2Low = b2 - (b2High = LinearCombination.highPart(b2)), prod2High, a2High, b2High)) + (prod3Low = LinearCombination.prodLow(a3Low = a3 - (a3High = LinearCombination.highPart(a3)), b3Low = b3 - (b3High = LinearCombination.highPart(b3)), prod3High, a3High, b3High)) + (prod4Low = LinearCombination.prodLow(a4Low = a4 - (a4High = LinearCombination.highPart(a4)), b4Low = b4 - (b4High = LinearCombination.highPart(b4)), prod4High, a4High, b4High)) + (s12Low = prod2High - (s12High - (s12Prime = s12High - prod2High)) + (prod1High - s12Prime)) + (s123Low = prod3High - (s123High - (s123Prime = s123High - prod3High)) + (s12High - s123Prime)) + (s1234Low = prod4High - (s1234High - (s1234Prime = s1234High - prod4High)) + (s123High - s1234Prime)));
        if (Double.isNaN(result)) {
            result = a1 * b1 + a2 * b2 + a3 * b3 + a4 * b4;
        }
        return result;
    }

    private static double highPart(double value) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(value) & 0xFFFFFFFFF8000000L);
    }

    private static double prodLow(double aLow, double bLow, double prodHigh, double aHigh, double bHigh) {
        return aLow * bLow - (prodHigh - aHigh * bHigh - aLow * bHigh - aHigh * bLow);
    }
}

