/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.field;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.numbers.field.Field;

public class FieldSquareMatrix<T> {
    private final Field<T> field;
    private final int dim;
    private final T[] data;

    private FieldSquareMatrix(Field<T> f, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Negative size");
        }
        this.field = f;
        this.dim = n;
        this.data = new Object[n * n];
    }

    public static <T> FieldSquareMatrix<T> create(Field<T> f, int n) {
        return new FieldSquareMatrix<T>(f, n);
    }

    public static <T> FieldSquareMatrix<T> zero(Field<T> f, int n) {
        return FieldSquareMatrix.create(f, n).fill(f.zero());
    }

    public static <T> FieldSquareMatrix<T> identity(Field<T> f, int n) {
        FieldSquareMatrix<T> r = FieldSquareMatrix.zero(f, n);
        for (int i = 0; i < n; ++i) {
            r.set(i, i, f.one());
        }
        return r;
    }

    public FieldSquareMatrix<T> copy() {
        FieldSquareMatrix<T> r = FieldSquareMatrix.create(this.field, this.dim);
        System.arraycopy(this.data, 0, r.data, 0, this.data.length);
        return r;
    }

    public int getDimension() {
        return this.dim;
    }

    public Field<T> getField() {
        return this.field;
    }

    public FieldSquareMatrix<T> fill(T value) {
        Arrays.fill(this.data, value);
        return this;
    }

    public T get(int i, int j) {
        return this.data[i * this.dim + j];
    }

    public void set(int i, int j, T value) {
        this.data[i * this.dim + j] = value;
    }

    public FieldSquareMatrix<T> add(FieldSquareMatrix<T> other) {
        this.checkDimension(other);
        FieldSquareMatrix<T> r = FieldSquareMatrix.create(this.field, this.dim);
        for (int i = 0; i < this.data.length; ++i) {
            r.data[i] = this.field.add(this.data[i], other.data[i]);
        }
        return r;
    }

    public FieldSquareMatrix<T> subtract(FieldSquareMatrix<T> other) {
        this.checkDimension(other);
        FieldSquareMatrix<T> r = FieldSquareMatrix.create(this.field, this.dim);
        for (int i = 0; i < this.data.length; ++i) {
            r.data[i] = this.field.subtract(this.data[i], other.data[i]);
        }
        return r;
    }

    public FieldSquareMatrix<T> negate() {
        FieldSquareMatrix<T> r = FieldSquareMatrix.create(this.field, this.dim);
        for (int i = 0; i < this.data.length; ++i) {
            r.data[i] = this.field.negate(this.data[i]);
        }
        return r;
    }

    public FieldSquareMatrix<T> multiply(FieldSquareMatrix<T> other) {
        this.checkDimension(other);
        FieldSquareMatrix<T> r = FieldSquareMatrix.zero(this.field, this.dim);
        for (int i = 0; i < this.dim; ++i) {
            int o1 = i * this.dim;
            for (int j = 0; j < this.dim; ++j) {
                int o2 = o1 + j;
                for (int k = 0; k < this.dim; ++k) {
                    r.data[o2] = this.field.add(r.data[o2], this.field.multiply(this.data[o1 + k], other.data[k * this.dim + j]));
                }
            }
        }
        return r;
    }

    public FieldSquareMatrix<T> pow(int p) {
        if (p < 0) {
            throw new IllegalArgumentException("Negative exponent: " + p);
        }
        if (p == 0) {
            return FieldSquareMatrix.identity(this.field, this.dim);
        }
        if (p == 1) {
            return this.copy();
        }
        int power = p - 1;
        char[] binary = Integer.toBinaryString(power).toCharArray();
        ArrayList<Integer> nonZeroPositions = new ArrayList<Integer>();
        for (int i = 0; i < binary.length; ++i) {
            if (binary[i] != '1') continue;
            int pos = binary.length - i - 1;
            nonZeroPositions.add(pos);
        }
        ArrayList<FieldSquareMatrix<T>> results = new ArrayList<FieldSquareMatrix<T>>(binary.length);
        results.add(this);
        for (int i = 1; i < binary.length; ++i) {
            FieldSquareMatrix s = (FieldSquareMatrix)results.get(i - 1);
            FieldSquareMatrix<T> r = s.multiply(s);
            results.add(r);
        }
        FieldSquareMatrix<T> r = this;
        for (Integer i : nonZeroPositions) {
            r = r.multiply((FieldSquareMatrix)results.get(i));
        }
        return r;
    }

    private void checkDimension(FieldSquareMatrix<T> other) {
        if (this.dim != other.dim) {
            throw new IllegalArgumentException("Dimension mismatch: " + this.dim + " != " + other.dim);
        }
    }
}

