/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.field;

import org.apache.commons.numbers.core.NativeOperators;
import org.apache.commons.numbers.core.Precision;

public class FP64
extends Number
implements NativeOperators<FP64>,
Comparable<FP64> {
    private static final FP64 ZERO = new FP64(0.0);
    private static final FP64 ONE = new FP64(1.0);
    private final double value;

    private FP64(double value) {
        this.value = value;
    }

    public static FP64 of(double value) {
        return new FP64(value);
    }

    public FP64 add(FP64 a) {
        return new FP64(this.value + a.value);
    }

    public FP64 negate() {
        return new FP64(-this.value);
    }

    public FP64 multiply(FP64 a) {
        return new FP64(this.value * a.value);
    }

    public FP64 reciprocal() {
        return new FP64(1.0 / this.value);
    }

    public FP64 subtract(FP64 a) {
        return new FP64(this.value - a.value);
    }

    public FP64 divide(FP64 a) {
        return new FP64(this.value / a.value);
    }

    public FP64 multiply(int n) {
        return new FP64(this.value * (double)n);
    }

    public FP64 pow(int n) {
        if (n == 0) {
            return ONE;
        }
        return new FP64(Math.pow(this.value, n));
    }

    public boolean equals(Object other) {
        if (other instanceof FP64) {
            FP64 o = (FP64)other;
            return Precision.equals((double)this.value, (double)o.value, (int)1);
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public int compareTo(FP64 other) {
        return Double.compare(this.value, other.value);
    }

    public FP64 zero() {
        return ZERO;
    }

    public FP64 one() {
        return ONE;
    }
}

