/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

public class Digamma {
    private static final double GAMMA = 0.5772156649015329;
    private static final double C_LIMIT = 49.0;
    private static final double S_LIMIT = 1.0E-5;
    private static final double F_M1_12 = -0.08333333333333333;
    private static final double F_1_120 = 0.008333333333333333;
    private static final double F_M1_252 = -0.003968253968253968;

    private Digamma() {
    }

    public static double value(double x) {
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            return x;
        }
        double digamma = 0.0;
        if (x < 0.0) {
            digamma -= Math.PI / Math.tan(Math.PI * x);
            x = 1.0 - x;
        }
        if (x > 0.0 && x <= 1.0E-5) {
            return digamma - 0.5772156649015329 - 1.0 / x;
        }
        while (x < 49.0) {
            digamma -= 1.0 / x;
            x += 1.0;
        }
        double inv = 1.0 / (x * x);
        return digamma += Math.log(x) - 0.5 / x + inv * (-0.08333333333333333 + inv * (0.008333333333333333 + -0.003968253968253968 * inv));
    }
}

