/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.factory.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.apache.commons.proxy.ProxyFactory;
import org.apache.commons.proxy.exception.ProxyFactoryException;

public abstract class AbstractSubclassingProxyFactory
extends ProxyFactory {
    private static boolean hasSuitableDefaultConstructor(Class superclass) {
        Constructor<?>[] declaredConstructors = superclass.getDeclaredConstructors();
        for (int i = 0; i < declaredConstructors.length; ++i) {
            Constructor<?> constructor = declaredConstructors[i];
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers()) && !Modifier.isProtected(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }

    protected static Class[] toInterfaces(Class[] proxyClasses) {
        LinkedList<Class> interfaces = new LinkedList<Class>();
        for (int i = 0; i < proxyClasses.length; ++i) {
            Class proxyInterface = proxyClasses[i];
            if (!proxyInterface.isInterface()) continue;
            interfaces.add(proxyInterface);
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    private static Class[] toNonInterfaces(Class[] proxyClasses) {
        LinkedList<Class> superclasses = new LinkedList<Class>();
        for (int i = 0; i < proxyClasses.length; ++i) {
            Class proxyClass = proxyClasses[i];
            if (proxyClass.isInterface()) continue;
            superclasses.add(proxyClass);
        }
        return superclasses.toArray(new Class[superclasses.size()]);
    }

    public boolean canProxy(Class[] proxyClasses) {
        try {
            AbstractSubclassingProxyFactory.getSuperclass(proxyClasses);
            return true;
        }
        catch (ProxyFactoryException e) {
            return false;
        }
    }

    public static Class getSuperclass(Class[] proxyClasses) {
        Class[] superclasses = AbstractSubclassingProxyFactory.toNonInterfaces(proxyClasses);
        switch (superclasses.length) {
            case 0: {
                return Object.class;
            }
            case 1: {
                Class superclass = superclasses[0];
                if (Modifier.isFinal(superclass.getModifiers())) {
                    throw new ProxyFactoryException("Proxy class cannot extend " + superclass.getName() + " as it is final.");
                }
                if (!AbstractSubclassingProxyFactory.hasSuitableDefaultConstructor(superclass)) {
                    throw new ProxyFactoryException("Proxy class cannot extend " + superclass.getName() + ", because it has no visible \"default\" constructor.");
                }
                return superclass;
            }
        }
        StringBuffer errorMessage = new StringBuffer("Proxy class cannot extend ");
        for (int i = 0; i < superclasses.length; ++i) {
            Class c = superclasses[i];
            errorMessage.append(c.getName());
            if (i == superclasses.length - 1) continue;
            errorMessage.append(", ");
        }
        errorMessage.append("; multiple inheritance not allowed.");
        throw new ProxyFactoryException(errorMessage.toString());
    }
}

