/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.interceptor;

import org.apache.commons.logging.Log;
import org.apache.commons.proxy.Interceptor;
import org.apache.commons.proxy.Invocation;
import org.apache.commons.proxy.ProxyUtils;

public class LoggingInterceptor
implements Interceptor {
    private static final int BUFFER_SIZE = 100;
    private Log log;

    public LoggingInterceptor(Log log) {
        this.log = log;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (this.log.isDebugEnabled()) {
            String methodName = invocation.getMethod().getName();
            this.entry(methodName, invocation.getArguments());
            try {
                Object result = invocation.proceed();
                if (Void.TYPE.equals(invocation.getMethod().getReturnType())) {
                    this.voidExit(methodName);
                } else {
                    this.exit(methodName, result);
                }
                return result;
            }
            catch (Throwable t) {
                this.exception(methodName, t);
                throw t;
            }
        }
        return invocation.proceed();
    }

    private void entry(String methodName, Object[] args) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("BEGIN ");
        buffer.append(methodName);
        buffer.append("(");
        int count = args.length;
        for (int i = 0; i < count; ++i) {
            Object arg = args[i];
            if (i > 0) {
                buffer.append(", ");
            }
            this.convert(buffer, arg);
        }
        buffer.append(")");
        this.log.debug((Object)buffer.toString());
    }

    private void convert(StringBuffer buffer, Object input) {
        if (input == null) {
            buffer.append("<null>");
            return;
        }
        if (!(input instanceof Object[])) {
            buffer.append(input.toString());
            return;
        }
        buffer.append("(");
        buffer.append(ProxyUtils.getJavaClassName(input.getClass()));
        buffer.append("){");
        Object[] array = (Object[])input;
        int count = array.length;
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.convert(buffer, array[i]);
        }
        buffer.append("}");
    }

    private void exception(String methodName, Throwable t) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("EXCEPTION ");
        buffer.append(methodName);
        buffer.append("() -- ");
        buffer.append(t.getClass().getName());
        this.log.debug((Object)buffer.toString(), t);
    }

    private void exit(String methodName, Object result) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("END ");
        buffer.append(methodName);
        buffer.append("() [");
        this.convert(buffer, result);
        buffer.append("]");
        this.log.debug((Object)buffer.toString());
    }

    private void voidExit(String methodName) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("END ");
        buffer.append(methodName);
        buffer.append("()");
        this.log.debug((Object)buffer.toString());
    }
}

