/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InverseTransformDiscreteSampler;
import org.apache.commons.statistics.distribution.DiscreteDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

abstract class AbstractDiscreteDistribution
implements DiscreteDistribution {
    AbstractDiscreteDistribution() {
    }

    @Override
    public double probability(int x0, int x1) {
        if (x1 < x0) {
            throw new DistributionException("{0} < {1}", x1, x0);
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    @Override
    public int inverseCumulativeProbability(double p) {
        boolean chebyshevApplies;
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", p, 0, 1);
        }
        int lower = this.getSupportLowerBound();
        if (p == 0.0) {
            return lower;
        }
        if (lower == Integer.MIN_VALUE) {
            if (this.checkedCumulativeProbability(lower) >= p) {
                return lower;
            }
        } else {
            --lower;
        }
        int upper = this.getSupportUpperBound();
        if (p == 1.0) {
            return upper;
        }
        double mu = this.getMean();
        double sigma = Math.sqrt(this.getVariance());
        boolean bl = chebyshevApplies = !Double.isInfinite(mu) && !Double.isNaN(mu) && !Double.isInfinite(sigma) && !Double.isNaN(sigma) && sigma != 0.0;
        if (chebyshevApplies) {
            double k = Math.sqrt((1.0 - p) / p);
            double tmp = mu - k * sigma;
            if (tmp > (double)lower) {
                lower = (int)Math.ceil(tmp) - 1;
            }
            if ((tmp = mu + (k = 1.0 / k) * sigma) < (double)upper) {
                upper = (int)Math.ceil(tmp) - 1;
            }
        }
        return this.solveInverseCumulativeProbability(p, lower, upper);
    }

    private int solveInverseCumulativeProbability(double p, int lowerBound, int upperBound) {
        int lower = lowerBound;
        int upper = upperBound;
        while (lower + 1 < upper) {
            double pm;
            int xm = (lower + upper) / 2;
            if (xm < lower || xm > upper) {
                xm = lower + (upper - lower) / 2;
            }
            if ((pm = this.checkedCumulativeProbability(xm)) >= p) {
                upper = xm;
                continue;
            }
            lower = xm;
        }
        return upper;
    }

    private double checkedCumulativeProbability(int argument) {
        double result = this.cumulativeProbability(argument);
        if (Double.isNaN(result)) {
            throw new IllegalStateException("Internal error");
        }
        return result;
    }

    public static int[] sample(int n, DiscreteDistribution.Sampler sampler) {
        int[] samples = new int[n];
        for (int i = 0; i < n; ++i) {
            samples[i] = sampler.sample();
        }
        return samples;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((InverseTransformDiscreteSampler)new InverseTransformDiscreteSampler(rng, this::inverseCumulativeProbability)).sample();
    }
}

