/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.GammaDistribution;

public class ChiSquaredDistribution
extends AbstractContinuousDistribution {
    private final GammaDistribution gamma;

    public ChiSquaredDistribution(double degreesOfFreedom) {
        this.gamma = new GammaDistribution(degreesOfFreedom / 2.0, 2.0);
    }

    public double getDegreesOfFreedom() {
        return this.gamma.getShape() * 2.0;
    }

    @Override
    public double density(double x) {
        return this.gamma.density(x);
    }

    @Override
    public double logDensity(double x) {
        return this.gamma.logDensity(x);
    }

    @Override
    public double cumulativeProbability(double x) {
        return this.gamma.cumulativeProbability(x);
    }

    @Override
    public double getMean() {
        return this.getDegreesOfFreedom();
    }

    @Override
    public double getVariance() {
        return 2.0 * this.getDegreesOfFreedom();
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return this.gamma.createSampler(rng);
    }
}

