/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs;

import org.apache.commons.vfs.FileSystemOptions;

public abstract class FileSystemConfigBuilder {
    private static final String PREFIX = "vfs.";
    private final String prefix;

    protected FileSystemConfigBuilder() {
        this.prefix = PREFIX;
    }

    protected FileSystemConfigBuilder(String component) {
        this.prefix = PREFIX + component;
    }

    protected void setParam(FileSystemOptions opts, String name, Object value) {
        opts.setOption(this.getConfigClass(), name, value);
    }

    protected Object getParam(FileSystemOptions opts, String name) {
        if (opts == null) {
            return null;
        }
        return opts.getOption(this.getConfigClass(), name);
    }

    protected boolean hasParam(FileSystemOptions opts, String name) {
        return opts != null && opts.hasOption(this.getConfigClass(), name);
    }

    protected boolean hasObject(FileSystemOptions opts, String name) {
        return this.hasParam(opts, name) || System.getProperties().containsKey(PREFIX + name);
    }

    protected Boolean getBoolean(FileSystemOptions opts, String name) {
        return this.getBoolean(opts, name, null);
    }

    protected boolean getBoolean(FileSystemOptions opts, String name, boolean defaultValue) {
        return this.getBoolean(opts, name, new Boolean(defaultValue));
    }

    protected Boolean getBoolean(FileSystemOptions opts, String name, Boolean defaultValue) {
        Boolean value = (Boolean)this.getParam(opts, name);
        if (value == null) {
            String str = System.getProperty(PREFIX + name);
            if (str == null) {
                return defaultValue;
            }
            value = Boolean.valueOf(str);
        }
        return value;
    }

    protected Byte getByte(FileSystemOptions opts, String name) {
        return this.getByte(opts, name, null);
    }

    protected byte getByte(FileSystemOptions opts, String name, byte defaultValue) {
        return this.getByte(opts, name, new Byte(defaultValue));
    }

    protected Byte getByte(FileSystemOptions opts, String name, Byte defaultValue) {
        Byte value = (Byte)this.getParam(opts, name);
        if (value == null) {
            String str = System.getProperty(this.prefix + name);
            if (str == null) {
                return defaultValue;
            }
            value = Byte.valueOf(str);
        }
        return value;
    }

    protected Character getCharacter(FileSystemOptions opts, String name) {
        return this.getCharacter(opts, name, null);
    }

    protected char getCharacter(FileSystemOptions opts, String name, char defaultValue) {
        return this.getCharacter(opts, name, new Character(defaultValue)).charValue();
    }

    protected Character getCharacter(FileSystemOptions opts, String name, Character defaultValue) {
        Character value = (Character)this.getParam(opts, name);
        if (value == null) {
            String str = System.getProperty(this.prefix + name);
            if (str == null || str.length() <= 0) {
                return defaultValue;
            }
            value = new Character(str.charAt(0));
        }
        return value;
    }

    protected Double getDouble(FileSystemOptions opts, String name) {
        return this.getDouble(opts, name, null);
    }

    protected double getDouble(FileSystemOptions opts, String name, double defaultValue) {
        return this.getDouble(opts, name, new Double(defaultValue));
    }

    protected Double getDouble(FileSystemOptions opts, String name, Double defaultValue) {
        Double value = (Double)this.getParam(opts, name);
        if (value == null) {
            String str = System.getProperty(this.prefix + name);
            if (str == null || str.length() <= 0) {
                return defaultValue;
            }
            value = Double.valueOf(str);
        }
        return value;
    }

    protected Float getFloat(FileSystemOptions opts, String name) {
        return this.getFloat(opts, name, null);
    }

    protected float getFloat(FileSystemOptions opts, String name, float defaultValue) {
        return this.getFloat(opts, name, new Float(defaultValue)).floatValue();
    }

    protected Float getFloat(FileSystemOptions opts, String name, Float defaultValue) {
        Float value = (Float)this.getParam(opts, name);
        if (value == null) {
            String str = System.getProperty(this.prefix + name);
            if (str == null || str.length() <= 0) {
                return defaultValue;
            }
            value = Float.valueOf(str);
        }
        return value;
    }

    protected Integer getInteger(FileSystemOptions opts, String name) {
        return this.getInteger(opts, name, null);
    }

    protected int getInteger(FileSystemOptions opts, String name, int defaultValue) {
        return this.getInteger(opts, name, new Integer(defaultValue));
    }

    protected Integer getInteger(FileSystemOptions opts, String name, Integer defaultValue) {
        Integer value = (Integer)this.getParam(opts, name);
        if (value == null) {
            String str = System.getProperty(this.prefix + name);
            if (str == null) {
                return defaultValue;
            }
            value = Integer.valueOf(str);
        }
        return value;
    }

    protected Long getLong(FileSystemOptions opts, String name) {
        return this.getLong(opts, name, null);
    }

    protected long getLong(FileSystemOptions opts, String name, long defaultValue) {
        return this.getLong(opts, name, new Long(defaultValue));
    }

    protected Long getLong(FileSystemOptions opts, String name, Long defaultValue) {
        Long value = (Long)this.getParam(opts, name);
        if (value == null) {
            String str = System.getProperty(this.prefix + name);
            if (str == null) {
                return defaultValue;
            }
            value = Long.valueOf(str);
        }
        return value;
    }

    protected Short getShort(FileSystemOptions opts, String name) {
        return this.getShort(opts, name, null);
    }

    protected short getShort(FileSystemOptions opts, String name, short defaultValue) {
        return this.getShort(opts, name, new Short(defaultValue));
    }

    protected Short getShort(FileSystemOptions opts, String name, Short defaultValue) {
        Short value = (Short)this.getParam(opts, name);
        if (value == null) {
            String str = System.getProperty(this.prefix + name);
            if (str == null) {
                return defaultValue;
            }
            value = Short.valueOf(str);
        }
        return value;
    }

    protected String getString(FileSystemOptions opts, String name) {
        return this.getString(opts, name, null);
    }

    protected String getString(FileSystemOptions opts, String name, String defaultValue) {
        String value = (String)this.getParam(opts, name);
        if (value == null && (value = System.getProperty(this.prefix + name)) == null) {
            return defaultValue;
        }
        return value;
    }

    protected abstract Class getConfigClass();
}

