/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.cache.AbstractFilesCache;
import org.apache.commons.vfs.util.Messages;

public class LRUFilesCache
extends AbstractFilesCache {
    private Log log = LogFactory.getLog((Class)LRUFilesCache.class);
    private final Map filesystemCache = new HashMap(10);
    private final int lruSize;

    public LRUFilesCache() {
        this(100);
    }

    public LRUFilesCache(int lruSize) {
        this.lruSize = lruSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFile(FileObject file) {
        LRUFilesCache lRUFilesCache = this;
        synchronized (lRUFilesCache) {
            Map files = this.getOrCreateFilesystemCache(file.getFileSystem());
            files.put(file.getName(), file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getFile(FileSystem filesystem, FileName name) {
        LRUFilesCache lRUFilesCache = this;
        synchronized (lRUFilesCache) {
            Map files = this.getOrCreateFilesystemCache(filesystem);
            return (FileObject)files.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(FileSystem filesystem) {
        LRUFilesCache lRUFilesCache = this;
        synchronized (lRUFilesCache) {
            Map files = this.getOrCreateFilesystemCache(filesystem);
            files.clear();
            this.filesystemCache.remove(filesystem);
        }
    }

    protected Map getOrCreateFilesystemCache(FileSystem filesystem) {
        Object files = (Map)this.filesystemCache.get(filesystem);
        if (files == null) {
            files = new MyLRUMap(filesystem, this.lruSize);
            this.filesystemCache.put(filesystem, files);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        LRUFilesCache lRUFilesCache = this;
        synchronized (lRUFilesCache) {
            this.filesystemCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(FileSystem filesystem, FileName name) {
        LRUFilesCache lRUFilesCache = this;
        synchronized (lRUFilesCache) {
            Map files = this.getOrCreateFilesystemCache(filesystem);
            files.remove(name);
            if (files.size() < 1) {
                this.filesystemCache.remove(filesystem);
            }
        }
    }

    public void touchFile(FileObject file) {
        this.getFile(file.getFileSystem(), file.getName());
    }

    private class MyLRUMap
    extends LRUMap {
        final FileSystem filesystem;

        public MyLRUMap(FileSystem filesystem, int size) {
            super(size, true);
            this.filesystem = filesystem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean removeLRU(AbstractLinkedMap.LinkEntry linkEntry) {
            LRUFilesCache lRUFilesCache = LRUFilesCache.this;
            synchronized (lRUFilesCache) {
                FileObject file = (FileObject)linkEntry.getValue();
                if (file.isAttached() || file.isContentOpen()) {
                    return false;
                }
                if (super.removeLRU(linkEntry)) {
                    try {
                        file.close();
                    }
                    catch (FileSystemException e) {
                        VfsLog.warn(LRUFilesCache.this.getLogger(), LRUFilesCache.this.log, Messages.getString("vfs.impl/LRUFilesCache-remove-ex.warn"), e);
                    }
                    Map files = (Map)LRUFilesCache.this.filesystemCache.get(this.filesystem);
                    if (files.size() < 1) {
                        LRUFilesCache.this.filesystemCache.remove(this.filesystem);
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

