/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.ftp.FTPClientWrapper;
import org.apache.commons.vfs.provider.ftp.FtpClient;
import org.apache.commons.vfs.provider.ftp.FtpFileObject;
import org.apache.commons.vfs.provider.ftp.FtpFileProvider;

public class FtpFileSystem
extends AbstractFileSystem {
    private static final Log log = LogFactory.getLog((Class)FtpFileSystem.class);
    private FtpClient idleClient;

    protected FtpFileSystem(GenericFileName rootName, FtpClient ftpClient, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.idleClient = ftpClient;
    }

    protected void doCloseCommunicationLink() {
        if (this.idleClient != null) {
            this.closeConnection(this.idleClient);
            this.idleClient = null;
        }
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(FtpFileProvider.capabilities);
    }

    private void closeConnection(FtpClient client) {
        try {
            if (client.isConnected()) {
                client.disconnect();
            }
        }
        catch (IOException e) {
            VfsLog.warn(this.getLogger(), log, "vfs.provider.ftp/close-connection.error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FtpClient getClient() throws FileSystemException {
        FtpFileSystem ftpFileSystem = this;
        synchronized (ftpFileSystem) {
            if (this.idleClient == null || !this.idleClient.isConnected()) {
                this.idleClient = null;
                FTPClientWrapper ftpClient = new FTPClientWrapper((GenericFileName)this.getRoot().getName(), this.getFileSystemOptions());
                return ftpClient;
            }
            FtpClient client = this.idleClient;
            this.idleClient = null;
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putClient(FtpClient client) {
        FtpFileSystem ftpFileSystem = this;
        synchronized (ftpFileSystem) {
            if (this.idleClient == null) {
                this.idleClient = client;
            } else {
                this.closeConnection(client);
            }
        }
    }

    protected FileObject createFile(FileName name) throws FileSystemException {
        return new FtpFileObject(name, this, this.getRootName());
    }
}

